/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.BindEvent;
import com.onemoonscientific.swank.SwkBind;
import com.onemoonscientific.swank.SwkBinding;
import com.onemoonscientific.swank.SwkListener;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventObject;
import tcl.lang.Interp;
import tcl.lang.TclEvent;
import tcl.lang.TclException;

public class SwkAppListener
implements PropertyChangeListener,
SwkListener {
    Interp interp;
    String command = "puts App";
    ArrayList<SwkBinding> bindings;

    SwkAppListener(Interp interp) {
        this.interp = interp;
        this.bindings = new ArrayList();
    }

    public void setCommand(String name) {
        this.command = name;
    }

    public String getCommand() {
        return this.command;
    }

    public void setBinding(SwkBinding newBinding) {
        SwkBind.setBinding(this.bindings, newBinding);
    }

    public void processEvent(EventObject eventObject, Object obj, int subtype) {
        PropertyChangeEvent e = (PropertyChangeEvent)eventObject;
        for (int i = 0; i < this.bindings.size(); ++i) {
            SwkBinding binding = this.bindings.get(i);
            if (binding.subtype != subtype || binding.command == null || binding.command.length() == 0) continue;
            try {
                this.interp.eval(binding.command);
                continue;
            }
            catch (TclException tclE) {
                this.interp.addErrorInfo("\n    (\"binding\" script)");
                this.interp.backgroundError();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("activeWindow")) {
            Component newComp = (Component)e.getNewValue();
            Component oldComp = (Component)e.getOldValue();
            BindEvent bEvent = null;
            if (newComp == null) {
                bEvent = new BindEvent(this.interp, this, e, 6);
            } else if (oldComp == null) {
                bEvent = new BindEvent(this.interp, this, e, 5);
            }
            if (bEvent != null) {
                this.interp.getNotifier().queueEvent((TclEvent)bEvent, 0);
            }
        }
    }
}

