/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.scripting;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.ocamljava.runtime.support.scripting.OCamlScriptEngine;

public final class OCamlScriptEngineFactory
implements ScriptEngineFactory {
    private static final String ENGINE_NAME = "OCaml-Java";
    private static final String ENGINE_VERSION = "2.0-early-access9";
    private static final List<String> ENGINE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList("ml", "mli"));
    private static final List<String> ENGINE_MIME_TYPES = Collections.unmodifiableList(Arrays.asList("text/plain", "text/x-ocaml"));
    private static final List<String> ENGINE_NAMES = Collections.unmodifiableList(Arrays.asList("OCaml", "ocaml"));
    private static final String LANGUAGE_NAME = "OCaml";
    private static final String LANGUAGE_SHORT_NAME = "OCaml";
    private static final String LANGUAGE_VERSION = "4.00.1";
    private static final Map<String, Object> PARAMETERS;

    @Override
    public String getEngineName() {
        return ENGINE_NAME;
    }

    @Override
    public String getEngineVersion() {
        return ENGINE_VERSION;
    }

    @Override
    public List<String> getExtensions() {
        return ENGINE_EXTENSIONS;
    }

    @Override
    public String getLanguageName() {
        return "OCaml";
    }

    @Override
    public String getLanguageVersion() {
        return LANGUAGE_VERSION;
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        StringBuffer res = new StringBuffer();
        res.append(obj);
        res.append('#');
        res.append(m);
        for (String a : args) {
            res.append(' ');
            res.append(a);
        }
        return res.toString();
    }

    @Override
    public List<String> getMimeTypes() {
        return ENGINE_MIME_TYPES;
    }

    @Override
    public List<String> getNames() {
        return ENGINE_NAMES;
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        StringBuffer res = new StringBuffer();
        res.append("print_string ");
        res.append(toDisplay);
        return res.toString();
    }

    @Override
    public Object getParameter(String key) {
        return PARAMETERS.get(key);
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuffer res = new StringBuffer();
        for (String s : statements) {
            res.append(s);
            res.append(";\n");
        }
        return res.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new OCamlScriptEngine();
    }

    static {
        Map<String, Object> params = PARAMETERS = new HashMap<String, Object>();
        params.put("javax.script.engine", ENGINE_NAME);
        params.put("javax.script.engine_version", ENGINE_VERSION);
        params.put("javax.script.name", "OCaml");
        params.put("javax.script.language", "OCaml");
        params.put("javax.script.language_version", LANGUAGE_VERSION);
        params.put("THREADING", "THREAD-ISOLATED");
    }
}

