/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import org.ocamljava.runtime.values.Value;
import org.ocamljava.runtime.wrappers.OCamlUnit;
import org.ocamljava.runtime.wrappers.OCamlValue;
import org.ocamljava.runtime.wrappers.SimpleWrapper;
import org.ocamljava.runtime.wrappers.Wrapper;

public final class OCamlString
extends OCamlValue
implements CharSequence {
    public static final Wrapper<OCamlString> WRAPPER = new SimpleWrapper<OCamlString>(){

        @Override
        public OCamlString wrap(Value value) {
            return new OCamlString(value);
        }
    };

    private OCamlString(Value value) {
        super(value);
    }

    public Wrapper<? extends OCamlString> getWrapper() {
        return WRAPPER;
    }

    @Override
    public Wrapper<? extends OCamlValue> getWrapper(int n) {
        return OCamlUnit.WRAPPER;
    }

    public String stringValue() {
        return this.value.asString();
    }

    public byte byteAt(int n) {
        return this.value.getByte(n);
    }

    @Override
    public char charAt(int n) {
        return (char)this.value.getUnsignedByte(n);
    }

    public void setByteAt(int n, byte by) {
        this.value.setByte(n, by);
    }

    public void setCharAt(int n, char c) {
        this.value.setUnsignedByte(n, c);
    }

    @Override
    public int length() {
        return (int)this.value.sizeBytes();
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.value.asString().subSequence(n, n2);
    }

    @Override
    public int hashCode() {
        return this.value.asString().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OCamlString) {
            OCamlString oCamlString = (OCamlString)object;
            return this.value.asString().equals(oCamlString.value.asString());
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OCamlString(");
        stringBuilder.append(this.value.asString());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static OCamlString create(String string) {
        return new OCamlString(Value.createString(string));
    }

    public static OCamlString wrap(Value value) {
        assert (value != null) : "null v";
        return new OCamlString(value);
    }

    public static Wrapper<? extends OCamlString> wrapper() {
        return WRAPPER;
    }
}

