/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Lexing", source="byterun/lexing.c")
public final class Lexing {
    private static final long REFILL_BUFF = 0L;
    private static final long LEX_BUFFER = 1L;
    private static final long LEX_BUFFER_LEN = 2L;
    private static final long LEX_ABS_POS = 3L;
    private static final long LEX_START_POS = 4L;
    private static final long LEX_CURR_POS = 5L;
    private static final long LEX_LAST_POS = 6L;
    private static final long LEX_LAST_ACTION = 7L;
    private static final long LEX_EOF_REACHED = 8L;
    private static final long LEX_MEM = 9L;
    private static final long LEX_START_P = 10L;
    private static final long LEX_CURR_P = 11L;
    private static final long LEX_BASE = 0L;
    private static final long LEX_BACKTRK = 1L;
    private static final long LEX_DEFAULT = 2L;
    private static final long LEX_TRANS = 3L;
    private static final long LEX_CHECK = 4L;
    private static final long LEX_BASE_CODE = 5L;
    private static final long LEX_BACKTRK_CODE = 6L;
    private static final long LEX_DEFAULT_CODE = 7L;
    private static final long LEX_TRANS_CODE = 8L;
    private static final long LEX_CHECK_CODE = 9L;
    private static final long LEX_CODE = 10L;
    private static final int NO_CHAR = 256;
    private static final int NO_DEST = 255;
    private static final int NO_SRC = 255;

    private Lexing() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Lexing.lex_tables", "int", "Lexing.lexbuf"}, returnType="int")
    public static Value caml_lex_engine(Value value, Value value2, Value value3) throws Fail.Exception {
        int n = value2.asCastedInt();
        if (n >= 0) {
            value3.set(6L, value3.get(5L));
            value3.set(4L, value3.get(5L));
            value3.set(7L, Value.MINUS_ONE);
        } else {
            n = -n - 1;
        }
        int n2;
        while ((n2 = Lexing.getShort(value.get(0L), n)) >= 0) {
            int n3;
            int n4 = Lexing.getShort(value.get(1L), n);
            if (n4 >= 0) {
                value3.set(6L, value3.get(5L));
                value3.set(7L, Value.createLong(n4));
            }
            if (value3.get(5L).asLong() >= value3.get(2L).asLong()) {
                if (value3.get(8L) == Value.FALSE) {
                    return Value.createLong(-n - 1);
                }
                n3 = 256;
            } else {
                int n5 = value3.get(5L).asCastedInt();
                n3 = value3.get(1L).getUnsignedByte(n5);
                value3.set(5L, Value.createLong(n5 + 1));
            }
            n = Lexing.getShort(value.get(4L), n2 + n3) == n ? Lexing.getShort(value.get(3L), n2 + n3) : Lexing.getShort(value.get(2L), n);
            if (n < 0) {
                value3.set(5L, value3.get(6L));
                if (value3.get(7L) == Value.MINUS_ONE) {
                    Fail.failWith("lexing: empty token");
                    continue;
                }
                return value3.get(7L);
            }
            if (n3 != 256) continue;
            value3.set(8L, Value.FALSE);
        }
        return Value.createLong(-n2 - 1);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Lexing.lex_tables", "int", "Lexing.lexbuf"}, returnType="int")
    public static Value caml_new_lex_engine(Value value, Value value2, Value value3) throws Fail.Exception {
        int n = value2.asCastedInt();
        if (n >= 0) {
            value3.set(6L, value3.get(5L));
            value3.set(4L, value3.get(5L));
            value3.set(7L, Value.MINUS_ONE);
        } else {
            n = -n - 1;
        }
        while (true) {
            int n2;
            int n3;
            int n4;
            int n5;
            if ((n5 = Lexing.getShort(value.get(0L), n)) < 0) {
                n4 = Lexing.getShort(value.get(5L), n);
                Lexing.runTag(value.get(10L), n4, value3.get(9L));
                return Value.createLong(-n5 - 1);
            }
            n4 = Lexing.getShort(value.get(1L), n);
            if (n4 >= 0) {
                n3 = Lexing.getShort(value.get(6L), n);
                Lexing.runTag(value.get(10L), n3, value3.get(9L));
                value3.set(6L, value3.get(5L));
                value3.set(7L, Value.createLong(n4));
            }
            if (value3.get(5L).asLong() >= value3.get(2L).asLong()) {
                if (value3.get(8L) == Value.FALSE) {
                    return Value.createLong(-n - 1);
                }
                n2 = 256;
            } else {
                n3 = value3.get(5L).asCastedInt();
                n2 = value3.get(1L).getUnsignedByte(n3);
                value3.set(5L, Value.createLong(n3 + 1));
            }
            n3 = n;
            n = Lexing.getShort(value.get(4L), n5 + n2) == n ? Lexing.getShort(value.get(3L), n5 + n2) : Lexing.getShort(value.get(2L), n);
            if (n < 0) {
                value3.set(5L, value3.get(6L));
                if (value3.get(7L).asLong() == -1L) {
                    Fail.failWith("lexing: empty token");
                    continue;
                }
                return value3.get(7L);
            }
            int n6 = Lexing.getShort(value.get(5L), n3);
            int n7 = Lexing.getShort(value.get(9L), n6 + n2) == n3 ? Lexing.getShort(value.get(8L), n6 + n2) : Lexing.getShort(value.get(7L), n3);
            if (n7 > 0) {
                Lexing.runMem(value.get(10L), n7, value3.get(9L), value3.get(5L));
            }
            if (n2 != 256) continue;
            value3.set(8L, Value.FALSE);
        }
    }

    static int getShort(Value value, int n) {
        return value.getUnsignedByte(2 * n) + (value.getByte(2 * n + 1) << 8);
    }

    private static void runMem(Value value, int n, Value value2, Value value3) {
        int n2 = n;
        int n3;
        while ((n3 = value.getUnsignedByte(n2++)) != 255) {
            int n4;
            if ((n4 = value.getUnsignedByte(n2++)) == 255) {
                value2.set(n3, value3);
                continue;
            }
            value2.set(n3, value2.get(n4));
        }
        return;
    }

    private static void runTag(Value value, int n, Value value2) {
        int n2 = n;
        int n3;
        while ((n3 = value.getUnsignedByte(n2++)) != 255) {
            int n4;
            if ((n4 = value.getUnsignedByte(n2++)) == 255) {
                value2.set(n3, Value.MINUS_ONE);
                continue;
            }
            value2.set(n3, value2.get(n4));
        }
        return;
    }
}

