/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.javalibs.concurrent.STMSlot;
import org.ocamljava.runtime.primitives.javalibs.concurrent.STMTransaction;
import org.ocamljava.runtime.primitives.javalibs.concurrent.STMVariable;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="STM", source="")
public final class STM {
    private STM() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="unit")
    public static Value ocamljava_stm_init(Value value) throws Fail.Exception {
        STMSlot.init();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="STM.transaction")
    public static Value ocamljava_stm_make_transaction(Value value) throws Fail.Exception {
        STMTransaction sTMTransaction = new STMTransaction(STMSlot.get().getGlobalVersionClock().get());
        return Value.createInstance(sTMTransaction);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a"}, returnType="'a STM.ref")
    public static Value ocamljava_stm_make_ref(Value value) throws Fail.Exception {
        STMVariable sTMVariable = new STMVariable(value, 0);
        return Value.createInstance(sTMVariable);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"STM.transaction", "'a STM.ref"}, returnType="'a")
    public static Value ocamljava_stm_get(Value value, Value value2) throws Fail.Exception {
        STMTransaction sTMTransaction = (STMTransaction)value.asCustom();
        STMVariable sTMVariable = (STMVariable)value2.asCustom();
        return sTMTransaction.readVariable(sTMVariable);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"STM.transaction", "'a STM.ref", "'a"}, returnType="unit")
    public static Value ocamljava_stm_set(Value value, Value value2, Value value3) throws Fail.Exception {
        STMTransaction sTMTransaction = (STMTransaction)value.asCustom();
        STMVariable sTMVariable = (STMVariable)value2.asCustom();
        sTMTransaction.writeVariable(sTMVariable, value3);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"STM.transaction"}, returnType="unit")
    public static Value ocamljava_stm_commit(Value value) throws Fail.Exception {
        STMTransaction sTMTransaction = (STMTransaction)value.asCustom();
        sTMTransaction.commit();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"STM.transaction"}, returnType="unit")
    public static Value ocamljava_stm_invalidate(Value value) throws Fail.Exception {
        STMTransaction sTMTransaction = (STMTransaction)value.asCustom();
        sTMTransaction.invalidate();
        return Value.UNIT;
    }

    static void raiseRetry() throws Fail.Exception {
        Value value = CurrentContext.CODE_STATE.getCallback("Concurrent.STM.Retry");
        if (value != null) {
            Fail.raise(value);
        } else {
            Fail.invalidArgument("Exception Concurrent.STM.Retry not initialized");
        }
    }
}

