/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.canvas.ItemNode;
import com.onemoonscientific.swank.canvas.SwkShape;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

class ItemTreeNode
extends DefaultMutableTreeNode {
    ItemTreeNode() {
    }

    public Enumeration postorderEnumeration() {
        return new PostorderEnumeration(this);
    }

    public Enumeration reversePostorderEnumeration() {
        return new PostorderEnumeration(this, true);
    }

    public Enumeration depthFirstEnumeration() {
        return this.postorderEnumeration();
    }

    public Enumeration reverseDepthFirstEnumeration() {
        return this.reversePostorderEnumeration();
    }

    boolean checkHidden(TreeNode node) {
        SwkShape swkShape;
        boolean ok = true;
        if (node instanceof ItemTreeNode && (swkShape = (SwkShape)((ItemTreeNode)node).getUserObject()) instanceof ItemNode && swkShape.state == 2) {
            ok = false;
        }
        return ok;
    }

    public Enumeration children(boolean reversed) {
        if (reversed) {
            return new ReversedEnumeration();
        }
        return super.children();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class PostorderEnumeration
    implements Enumeration<TreeNode> {
        protected TreeNode root;
        protected TreeNode current = null;
        protected Enumeration<TreeNode> children;
        protected Enumeration<TreeNode> subtree;
        boolean reversed = false;

        public PostorderEnumeration(TreeNode rootNode) {
            this.root = rootNode;
            this.children = this.root.children();
            this.subtree = DefaultMutableTreeNode.EMPTY_ENUMERATION;
        }

        public PostorderEnumeration(TreeNode rootNode, boolean reversed) {
            this.root = rootNode;
            this.reversed = true;
            this.children = ((ItemTreeNode)this.root).children(reversed);
            this.subtree = DefaultMutableTreeNode.EMPTY_ENUMERATION;
        }

        @Override
        public boolean hasMoreElements() {
            this.current = this.scanForNextElement();
            return this.current != null;
        }

        @Override
        public TreeNode nextElement() {
            TreeNode returnValue = this.current;
            this.current = null;
            return returnValue;
        }

        public TreeNode scanForNextElement() {
            TreeNode retval = null;
            if (this.subtree.hasMoreElements()) {
                retval = this.subtree.nextElement();
            } else {
                while (this.children.hasMoreElements()) {
                    TreeNode testNode = this.children.nextElement();
                    if (!ItemTreeNode.this.checkHidden(testNode)) continue;
                    this.subtree = new PostorderEnumeration(testNode, this.reversed);
                    if (!this.subtree.hasMoreElements()) continue;
                    retval = this.subtree.nextElement();
                    break;
                }
                if (retval == null) {
                    retval = this.root;
                    this.root = null;
                }
            }
            return retval;
        }
    }

    final class ReversedEnumeration
    implements Enumeration {
        int nElements;

        ReversedEnumeration() {
            this.nElements = ItemTreeNode.this.getChildCount();
        }

        public boolean hasMoreElements() {
            return this.nElements > 0;
        }

        public Object nextElement() {
            --this.nElements;
            return ItemTreeNode.this.getChildAt(this.nElements);
        }
    }
}

