/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.ItemArc;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import java.awt.geom.Arc2D;
import tcl.lang.Interp;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclObject;

public class ExtentParameter
extends CanvasParameter {
    private static String name = "extent";
    private static double defValue = 90.0;
    private double newValue = defValue;

    public String getName() {
        return name;
    }

    public String getDefault() {
        return defValue + "";
    }

    public boolean isParameterLabel(String s) {
        return s.length() > 3 && "-extent".startsWith(s);
    }

    public TclObject getValue(Interp interp, SwkShape swkShape) throws TclException {
        if (swkShape == null) {
            throw new TclException(interp, "shape doesn't exist");
        }
        if (swkShape instanceof ItemArc) {
            Arc2D arc2D = ((ItemArc)swkShape).arc2D;
            return TclDouble.newInstance((double)arc2D.getAngleExtent());
        }
        throw new TclException(interp, "shape not arc");
    }

    public void setValue(Interp interp, SwkImageCanvas swkCanvas, TclObject arg) throws TclException {
        this.newValue = TclDouble.get((Interp)interp, (TclObject)arg);
    }

    public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
        if (swkShape != null && swkShape.shape != null && swkShape instanceof ItemArc) {
            Arc2D arc2D = ((ItemArc)swkShape).arc2D;
            arc2D.setAngleExtent(this.newValue);
            swkShape.applyCoordinates();
        }
    }
}

