/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkJTabbedPane;
import com.onemoonscientific.swank.UpdateOnEventThread;
import com.onemoonscientific.swank.Widgets;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class SwkJTabbedPaneWidgetCmd
implements Command {
    private static final String[] validCmds = new String[]{"cget", "configure", "add", "select", "tabconfigure", "tabcget", "tabcount", "index"};
    private static final int OPT_CGET = 0;
    private static final int OPT_CONFIGURE = 1;
    private static final int OPT_ADD = 2;
    private static final int OPT_SELECT = 3;
    private static final int OPT_TABCONFIGURE = 4;
    private static final int OPT_TABCGET = 5;
    private static final int OPT_TABCOUNT = 6;
    private static final int OPT_INDEX = 7;
    static boolean gotDefaults = false;
    Interp interp = null;

    SwkJTabbedPaneWidgetCmd() {
    }

    public static String[] getValidCmds() {
        return validCmds;
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        this.interp = interp;
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        TclObject tObj = (TclObject)Widgets.getWidget(interp, argv[0].toString());
        if (tObj == null) {
            throw new TclException(interp, "bad window path name \"" + argv[0].toString() + "\"");
        }
        SwkJTabbedPane swkjtabbedpane = (SwkJTabbedPane)ReflectObject.get((Interp)interp, (TclObject)tObj);
        switch (opt) {
            case 0: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                interp.setResult(swkjtabbedpane.jget(interp, argv[2]));
                break;
            }
            case 1: {
                if (!gotDefaults) {
                    swkjtabbedpane.setResourceDefaults();
                    gotDefaults = true;
                }
                if (argv.length == 2) {
                    swkjtabbedpane.jgetAll(interp);
                    break;
                }
                if (argv.length == 3) {
                    String result = swkjtabbedpane.jget(interp, argv[2]);
                    ResourceObject ro = (ResourceObject)SwkJTabbedPane.resourceDB.get(argv[2].toString());
                    if (ro == null) {
                        throw new TclException(interp, "unknown option \"" + argv[2].toString() + "\"");
                    }
                    TclObject list = TclList.newInstance();
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)argv[2].toString()));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.resource));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.className));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.defaultVal));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)result));
                    interp.setResult(list);
                    break;
                }
                swkjtabbedpane.configure(interp, argv, 2);
                break;
            }
            case 2: {
                this.add(interp, swkjtabbedpane, argv);
                break;
            }
            case 3: {
                this.select(interp, swkjtabbedpane, argv);
                break;
            }
            case 4: {
                this.tabConfigure(interp, swkjtabbedpane, argv);
                break;
            }
            case 5: {
                this.tabCGet(interp, swkjtabbedpane, argv);
                break;
            }
            case 6: {
                this.getTabCount(interp, swkjtabbedpane, argv);
                break;
            }
            case 7: {
                this.getIndex(interp, swkjtabbedpane, argv);
                break;
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    void add(Interp interp, SwkJTabbedPane swkjtabbedpane, TclObject[] argv) throws TclException {
        if (argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "window title");
        }
        TclObject tObj2 = (TclObject)Widgets.getWidget(interp, argv[2].toString());
        if (tObj2 == null) {
            throw new TclException(interp, "bad window path name \"" + argv[2].toString() + "\"");
        }
        JComponent jcomp = (JComponent)ReflectObject.get((Interp)interp, (TclObject)tObj2);
        new Add().exec(swkjtabbedpane, jcomp, argv[3].toString().intern());
    }

    void select(Interp interp, SwkJTabbedPane swkjtabbedpane, TclObject[] argv) throws TclException {
        if (argv.length != 2 && argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "index");
        }
        if (argv.length == 3) {
            int index = TclInteger.get((Interp)interp, (TclObject)argv[2]);
            new SetSelected().exec(swkjtabbedpane, index);
        } else {
            int index = new GetSelected().exec(swkjtabbedpane);
            interp.setResult(index);
        }
    }

    void tabConfigure(Interp interp, SwkJTabbedPane swkjtabbedpane, TclObject[] argv) throws TclException {
        if (argv.length < 5) {
            throw new TclNumArgsException(interp, 2, argv, "index item value ? item value ...?");
        }
        int index = TclInteger.get((Interp)interp, (TclObject)argv[2]);
        new TabConfigure().exec(swkjtabbedpane, index, 3, argv);
    }

    void tabCGet(Interp interp, SwkJTabbedPane swkjtabbedpane, TclObject[] argv) throws TclException {
        if (argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "index");
        }
        int index = TclInteger.get((Interp)interp, (TclObject)argv[2]);
        new TabCGet().exec(swkjtabbedpane, argv[3], index);
    }

    void getTabCount(Interp interp, SwkJTabbedPane swkjtabbedpane, TclObject[] argv) throws TclException {
        if (argv.length != 2) {
            throw new TclNumArgsException(interp, 2, argv, "");
        }
        int count = new GetTabCount().exec(swkjtabbedpane);
        interp.setResult(count);
    }

    void getIndex(Interp interp, SwkJTabbedPane swkjtabbedpane, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "selected");
        }
        int index = new GetSelected().exec(swkjtabbedpane);
        interp.setResult(index);
    }

    class GetTabCount
    extends GetValueOnEventThread {
        SwkJTabbedPane swkjtabbedpane = null;
        int count = -1;

        GetTabCount() {
        }

        int exec(SwkJTabbedPane swkjtabbedpane) {
            this.swkjtabbedpane = swkjtabbedpane;
            this.execOnThread();
            return this.count;
        }

        public void run() {
            this.count = this.swkjtabbedpane.getTabCount();
        }
    }

    class TabCGet
    extends GetValueOnEventThread {
        SwkJTabbedPane swkjtabbedpane = null;
        TclObject item = null;
        int index = -1;
        String errMessage = null;
        String sItem = null;
        String result = null;

        TabCGet() {
        }

        void exec(SwkJTabbedPane swkjtabbedpane, TclObject item, int index) throws TclException {
            this.swkjtabbedpane = swkjtabbedpane;
            this.item = item;
            this.index = index;
            this.sItem = item.toString();
            this.execOnThread();
            if (this.errMessage != null) {
                throw new TclException(SwkJTabbedPaneWidgetCmd.this.interp, this.errMessage);
            }
            SwkJTabbedPaneWidgetCmd.this.interp.setResult(this.result);
        }

        public void run() {
            this.result = this.swkjtabbedpane.tabCGet(this.sItem, this.index);
        }
    }

    class TabConfigure
    extends UpdateOnEventThread {
        SwkJTabbedPane swkjtabbedpane = null;
        int index = -1;
        TclObject[] argv = null;
        Color foreground = null;
        Color background = null;
        String title = null;
        String toolTipText = null;
        ImageIcon icon = null;
        String iconName = null;
        Integer underline = null;
        String state = null;

        TabConfigure() {
        }

        void exec(SwkJTabbedPane swkjtabbedpane, int index, int start, TclObject[] argv) throws TclException {
            this.swkjtabbedpane = swkjtabbedpane;
            this.index = index;
            this.argv = new TclObject[argv.length];
            if ((argv.length - start) % 2 != 0) {
                throw new TclNumArgsException(SwkJTabbedPaneWidgetCmd.this.interp, 0, argv, "-option value ? -option value? ...");
            }
            for (int i = start; i < argv.length; i += 2) {
                if (argv[i].toString().equals("-foreground")) {
                    this.foreground = SwankUtil.getColor(SwkJTabbedPaneWidgetCmd.this.interp, argv[i + 1]);
                    continue;
                }
                if (argv[i].toString().equals("-background")) {
                    this.background = SwankUtil.getColor(SwkJTabbedPaneWidgetCmd.this.interp, argv[i + 1]);
                    continue;
                }
                if (argv[i].toString().startsWith("-text")) {
                    this.title = argv[i + 1].toString();
                    continue;
                }
                if (argv[i].toString().startsWith("-tooltiptext")) {
                    this.toolTipText = argv[i + 1].toString();
                    continue;
                }
                if (argv[i].toString().startsWith("-state")) {
                    this.state = argv[i + 1].toString();
                    if (this.state.equals("normal") || this.state.equals("disabled")) continue;
                    throw new TclException(SwkJTabbedPaneWidgetCmd.this.interp, "state must be \"normal\" or \"disabled\"");
                }
                if (argv[i].toString().startsWith("-underline")) {
                    this.underline = TclInteger.get((Interp)SwkJTabbedPaneWidgetCmd.this.interp, (TclObject)argv[i + 1]);
                    continue;
                }
                if (!argv[i].toString().startsWith("-image")) continue;
                this.iconName = argv[i + 1].toString();
                this.icon = SwankUtil.getImageIcon(SwkJTabbedPaneWidgetCmd.this.interp, argv[i + 1]);
            }
            this.execOnThread();
        }

        public void run() {
            if (this.background != null) {
                this.swkjtabbedpane.setBackgroundAt(this.index, this.background);
            }
            if (this.foreground != null) {
                this.swkjtabbedpane.setForegroundAt(this.index, this.foreground);
            }
            if (this.title != null) {
                if (this.title.trim().equals("")) {
                    this.swkjtabbedpane.setTitleAt(this.index, null);
                } else {
                    this.swkjtabbedpane.setTitleAt(this.index, this.title);
                }
            }
            if (this.toolTipText != null) {
                if (this.toolTipText.trim().equals("")) {
                    this.swkjtabbedpane.setToolTipTextAt(this.index, null);
                } else {
                    this.swkjtabbedpane.setToolTipTextAt(this.index, this.toolTipText);
                }
            }
            if (this.iconName != null) {
                if (this.iconName.trim().equals("")) {
                    this.swkjtabbedpane.setIconAt(this.index, null);
                } else {
                    this.swkjtabbedpane.setIconAt(this.index, this.icon);
                }
            }
            if (this.underline != null) {
                this.swkjtabbedpane.setDisplayedMnemonicIndexAt(this.index, this.underline);
            }
            if (this.state != null) {
                if (this.state.equals("normal")) {
                    this.swkjtabbedpane.setEnabledAt(this.index, true);
                } else {
                    this.swkjtabbedpane.setEnabledAt(this.index, false);
                }
            }
        }
    }

    class SetSelected
    extends UpdateOnEventThread {
        SwkJTabbedPane swkjtabbedpane = null;
        int index = -1;

        SetSelected() {
        }

        void exec(SwkJTabbedPane swkjtabbedpane, int index) {
            this.swkjtabbedpane = swkjtabbedpane;
            this.index = index;
            this.execOnThread();
        }

        public void run() {
            this.swkjtabbedpane.setSelectedIndex(this.index);
        }
    }

    class GetSelected
    extends GetValueOnEventThread {
        SwkJTabbedPane swkjtabbedpane = null;
        int index = -1;

        GetSelected() {
        }

        int exec(SwkJTabbedPane swkjtabbedpane) {
            this.swkjtabbedpane = swkjtabbedpane;
            this.execOnThread();
            return this.index;
        }

        public void run() {
            this.index = this.swkjtabbedpane.getSelectedIndex();
        }
    }

    class Add
    extends UpdateOnEventThread {
        SwkJTabbedPane swkjtabbedpane = null;
        JComponent jcomp = null;
        String label = null;

        Add() {
        }

        void exec(SwkJTabbedPane swkjtabbedpane, JComponent jcomp, String label) {
            this.jcomp = jcomp;
            this.label = label;
            this.swkjtabbedpane = swkjtabbedpane;
            this.execOnThread();
        }

        public void run() {
            this.swkjtabbedpane.add((Component)this.jcomp, this.label);
        }
    }
}

