/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Signals;
import org.ocamljava.runtime.util.Signal;
import org.ocamljava.runtime.util.SignalKind;
import org.ocamljava.runtime.values.Value;

public final class SignalsState {
    private static final Value SIGNAL_DEFAULT_HANDLER = Value.ZERO;
    private static final Value SIGNAL_IGNORE_HANDLER = Value.ONE;
    private static final int SIG_SETMASK = 0;
    private static final int SIG_BLOCK = 1;
    private static final int SIG_UNBLOCK = 2;
    private final Context context;
    private final Map<Integer, Value> signals;
    private final Set<Integer> blockedSignals;
    private final Set<Integer> ignoredSignals;
    private Exception asyncException;

    SignalsState(Context ctxt) {
        assert (ctxt != null) : "null ctxt";
        this.context = ctxt;
        this.signals = new HashMap<Integer, Value>();
        this.blockedSignals = new HashSet<Integer>();
        this.ignoredSignals = new HashSet<Integer>();
        this.asyncException = null;
    }

    public Set<Integer> getBlockedSignals() {
        return this.blockedSignals;
    }

    public Set<Integer> getIgnoredSignals() {
        return this.ignoredSignals;
    }

    public void clearSignals() {
        Signals.unregisterContext(this.context);
        this.signals.clear();
        this.blockedSignals.clear();
        this.ignoredSignals.clear();
    }

    public Value getSignalHandler(int signum) {
        Value res = this.signals.get(signum);
        return res != null ? res : SIGNAL_DEFAULT_HANDLER;
    }

    public Set<Integer> getPendingSignals() {
        return Signals.getPendingSignals(this.blockedSignals);
    }

    public Set<Integer> blockSignals(int action, Set<Integer> s) {
        assert (s != null) : "null s";
        HashSet<Integer> res = new HashSet<Integer>(this.blockedSignals);
        switch (action) {
            case 0: {
                this.blockedSignals.clear();
                this.blockedSignals.addAll(s);
                break;
            }
            case 1: {
                this.blockedSignals.addAll(s);
                break;
            }
            case 2: {
                this.blockedSignals.removeAll(s);
                break;
            }
            default: {
                assert (false) : "invalid sigmask action";
                break;
            }
        }
        this.blockedSignals.remove(new Signal(SignalKind.KILL).getNumber());
        this.blockedSignals.remove(new Signal(SignalKind.STOP).getNumber());
        return res;
    }

    public int waitSignal(Set<Integer> s) throws FalseExit, Fail.Exception {
        assert (s != null) : "null s";
        return Signals.waitForSignal(this.context, s);
    }

    public Value installSignalHandler(Value signal, Value action) throws Fail.Exception {
        int signum = Signals.ocamlToSystemIdentifier(signal.asCastedInt());
        if (signum < 0) {
            Fail.invalidArgument("Sys.signal: unavailable signal");
        }
        if (signum == new Signal(SignalKind.KILL).getNumber() || signum == new Signal(SignalKind.STOP).getNumber()) {
            Fail.raiseSysError("Invalid argument");
        }
        if (action == SIGNAL_DEFAULT_HANDLER) {
            Signals.unregisterContext(signum, this.context);
            return this.registerSignal(signum, SIGNAL_DEFAULT_HANDLER);
        }
        if (action == SIGNAL_IGNORE_HANDLER) {
            Signals.registerContext(signum, this.context);
            return this.registerSignal(signum, SIGNAL_IGNORE_HANDLER);
        }
        Signals.registerContext(signum, this.context);
        return this.registerSignal(signum, action.get0());
    }

    private Value registerSignal(int signum, Value handler) {
        Value res = this.signals.put(signum, handler);
        if (res == null) {
            return SIGNAL_DEFAULT_HANDLER;
        }
        if (res.isBlock()) {
            return Value.createBlock(0, res);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsyncException(Exception e) {
        assert (e != null) : "null e";
        SignalsState signalsState = this;
        synchronized (signalsState) {
            this.asyncException = e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception getAndClearAsyncException() {
        Exception res;
        SignalsState signalsState = this;
        synchronized (signalsState) {
            res = this.asyncException;
            this.asyncException = null;
        }
        return res;
    }
}

