/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import org.ocamljava.runtime.values.Value;
import org.ocamljava.runtime.wrappers.OCamlNumber;
import org.ocamljava.runtime.wrappers.OCamlUnit;
import org.ocamljava.runtime.wrappers.OCamlValue;
import org.ocamljava.runtime.wrappers.SimpleWrapper;
import org.ocamljava.runtime.wrappers.Wrapper;

public final class OCamlFloat
extends OCamlValue
implements OCamlNumber {
    public static final Wrapper<OCamlFloat> WRAPPER = new SimpleWrapper<OCamlFloat>(){

        @Override
        public OCamlFloat wrap(Value v) {
            return new OCamlFloat(v);
        }
    };

    private OCamlFloat(Value v) {
        super(v);
    }

    public Wrapper<? extends OCamlFloat> getWrapper() {
        return WRAPPER;
    }

    @Override
    public Wrapper<? extends OCamlValue> getWrapper(int idx) {
        return OCamlUnit.WRAPPER;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value.asDouble();
    }

    @Override
    public double doubleValue() {
        return this.value.asDouble();
    }

    @Override
    public float floatValue() {
        return (float)this.value.asDouble();
    }

    @Override
    public int intValue() {
        return (int)this.value.asDouble();
    }

    @Override
    public long longValue() {
        return (long)this.value.asDouble();
    }

    @Override
    public short shortValue() {
        return (short)this.value.asDouble();
    }

    @Override
    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value.asDouble());
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OCamlFloat) {
            OCamlFloat that = (OCamlFloat)obj;
            return this.value.asDouble() == that.value.asDouble();
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OCamlFloat(");
        sb.append(this.value.asDouble());
        sb.append(")");
        return sb.toString();
    }

    public static OCamlFloat create(double v) {
        return new OCamlFloat(Value.createDouble(v));
    }

    public static OCamlFloat wrap(Value v) {
        assert (v != null) : "null v";
        return new OCamlFloat(v);
    }

    public static Wrapper<? extends OCamlFloat> wrapper() {
        return WRAPPER;
    }
}

