/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.javabase;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.stdlib.Sys;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="[XXX]", module="[XXX]", source="XXX.c")
public final class JavaString {
    private JavaString() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"string"}, returnType="java'lang'String java_instance")
    public static Value ocamljava_javastring_of_string(Value s) {
        return Value.createInstance(s.asString());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"java'lang'String java_instance"}, returnType="string")
    public static Value ocamljava_javastring_to_string(Value s) {
        return Value.createString((String)s.asCustom());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"java'lang'String java_instance"}, returnType="unit")
    public static Value ocamljava_javastring_print_string(Value s) throws Fail.Exception, FalseExit {
        JavaString.write(CurrentContext.getFilesState().getChannel(1), (String)s.asCustom(), false);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"java'lang'String java_instance"}, returnType="unit")
    public static Value ocamljava_javastring_print_endline(Value s) throws Fail.Exception, FalseExit {
        JavaString.write(CurrentContext.getFilesState().getChannel(1), (String)s.asCustom(), true);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"java'lang'String java_instance"}, returnType="unit")
    public static Value ocamljava_javastring_prerr_string(Value s) throws Fail.Exception, FalseExit {
        JavaString.write(CurrentContext.getFilesState().getChannel(2), (String)s.asCustom(), false);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"java'lang'String java_instance"}, returnType="unit")
    public static Value ocamljava_javastring_prerr_endline(Value s) throws Fail.Exception, FalseExit {
        JavaString.write(CurrentContext.getFilesState().getChannel(2), (String)s.asCustom(), true);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Pervasives.out_channel", "java'lang'String java_instance"}, returnType="unit")
    public static Value ocamljava_javastring_output_string(Value channel, Value s) throws Fail.Exception, FalseExit {
        JavaString.write((Channel)channel.asCustom(), (String)s.asCustom(), false);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="java'lang'String java_instance")
    public static Value ocamljava_javastring_read_line(Value unit) throws Fail.Exception, FalseExit {
        String res = JavaString.read(CurrentContext.getFilesState().getChannel(0));
        return Value.createInstance(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Pervasives.in_channel"}, returnType="java'lang'String java_instance")
    public static Value ocamljava_javastring_input_line(Value ch) throws Fail.Exception, FalseExit {
        String res = JavaString.read((Channel)ch.asCustom());
        return Value.createInstance(res);
    }

    private static void write(Channel ch, String s, boolean eol) throws Fail.Exception, FalseExit {
        try {
            CurrentContext.enterBlockingSection();
            ch.write(s.getBytes());
            if (eol) {
                ch.write("\n".getBytes());
                ch.flush();
            }
            CurrentContext.leaveBlockingSection();
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            CurrentContext.leaveBlockingSection();
            Sys.sysError(null, ioe.toString());
        }
    }

    private static String read(Channel ch) throws Fail.Exception, FalseExit {
        try {
            CurrentContext.enterBlockingSection();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
            byte[] b = new byte[1];
            int read = ch.read(b, 0, 1);
            while (read > 0 && b[0] != 10) {
                baos.write(b[0]);
                read = ch.read(b, 0, 1);
            }
            CurrentContext.leaveBlockingSection();
            if (baos.size() == 0 && read <= 0) {
                return null;
            }
            return baos.toString();
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            CurrentContext.leaveBlockingSection();
            Sys.sysError(null, ioe.toString());
            return null;
        }
    }
}

