/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.util.Arrays;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.values.AbstractDoubleArrayValue;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.DoubleArrayValue0;
import org.ocamljava.runtime.values.DoubleArrayValue1;
import org.ocamljava.runtime.values.DoubleArrayValue2;
import org.ocamljava.runtime.values.DoubleArrayValue3;
import org.ocamljava.runtime.values.DoubleArrayValue4;
import org.ocamljava.runtime.values.DoubleArrayValue5;
import org.ocamljava.runtime.values.DoubleArrayValue6;
import org.ocamljava.runtime.values.DoubleArrayValue7;
import org.ocamljava.runtime.values.DoubleArrayValue8;
import org.ocamljava.runtime.values.Value;
import sun.misc.Unsafe;

public final class UnsafeDoubleArrayValue
extends AbstractDoubleArrayValue {
    private int sizeTagged;
    private int sizeMinusOneTagged;
    private Value sizeWrapped;
    private double[] values;
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();

    UnsafeDoubleArrayValue(int sz) {
        super(254, (long)sz * 1L);
        this.values = new double[sz];
        this.sizeTagged = sz << 1 | 1;
        this.sizeMinusOneTagged = sz - 1 << 1 | 1;
        this.sizeWrapped = Value.createLong(sz);
    }

    UnsafeDoubleArrayValue(double[] vals) {
        super(254, (long)vals.length * 1L);
        int sz = vals.length;
        this.values = vals;
        this.sizeTagged = sz << 1 | 1;
        this.sizeMinusOneTagged = sz - 1 << 1 | 1;
        this.sizeWrapped = Value.createLong(sz);
    }

    @Override
    public double getDouble(long idx) throws ArrayIndexOutOfBoundsException {
        return UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + idx * (long)Unsafe.ARRAY_DOUBLE_INDEX_SCALE);
    }

    @Override
    public double getDouble(int idx) throws ArrayIndexOutOfBoundsException {
        return UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(idx * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public double getDouble0() {
        return UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(0 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public double getDouble1() {
        return UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(1 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public double getDouble2() {
        return UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(2 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public double getDouble3() {
        return UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(3 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public double getDouble4() {
        return UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(4 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public double getDouble5() {
        return UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(5 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public double getDouble6() {
        return UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(6 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public double getDouble7() {
        return UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(7 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public void setDouble(long idx, double x) throws ArrayIndexOutOfBoundsException {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + idx * (long)Unsafe.ARRAY_DOUBLE_INDEX_SCALE, x);
    }

    @Override
    public void setDouble(int idx, double x) throws ArrayIndexOutOfBoundsException {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(idx * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public void setDouble0(double x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(0 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public void setDouble1(double x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(1 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public void setDouble2(double x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(2 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public void setDouble3(double x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(3 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public void setDouble4(double x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(4 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public void setDouble5(double x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(5 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public void setDouble6(double x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(6 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public void setDouble7(double x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(7 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public long sizeDoubles() {
        return this.values.length;
    }

    @Override
    public long arrayLength() {
        return this.values.length;
    }

    @Override
    public long arrayLengthTagged() {
        return this.sizeTagged;
    }

    @Override
    public long arrayLengthMinusOneTagged() {
        return this.sizeMinusOneTagged;
    }

    @Override
    public Value arrayLengthWrapped() {
        return this.sizeWrapped;
    }

    @Override
    protected void truncateInstance(long sz) {
        int s = (int)(sz / 1L);
        this.values = Arrays.copyOf(this.values, s);
        this.sizeTagged = s << 1 | 1;
        this.sizeMinusOneTagged = s - 1 << 1 | 1;
        this.sizeWrapped = Value.createLong(s);
    }

    @Override
    public void copy(BlockValue src) {
        int len = (int)Math.min((long)this.values.length, src.sizeDoubles());
        for (int i = 0; i < len; ++i) {
            this.values[i] = src.getDouble(i);
        }
    }

    @Override
    public UnsafeDoubleArrayValue duplicate() {
        int len = this.values.length;
        UnsafeDoubleArrayValue res = new UnsafeDoubleArrayValue(len);
        System.arraycopy(this.values, 0, res.values, 0, len);
        return res;
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            dest[i] = Value.createDouble(this.values[i]);
        }
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = Value.createDouble(this.values[i]);
        }
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
        System.arraycopy(this.values, 0, dest, destOfs, this.values.length);
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = (long)this.values[i];
        }
    }

    @Override
    public Value subArray(long ofs, long len) {
        int l = (int)len;
        int o = (int)ofs;
        switch (l) {
            case 0: {
                return new DoubleArrayValue0();
            }
            case 1: {
                return new DoubleArrayValue1(this.values[o + 0]);
            }
            case 2: {
                return new DoubleArrayValue2(this.values[o + 0], this.values[o + 1]);
            }
            case 3: {
                return new DoubleArrayValue3(this.values[o + 0], this.values[o + 1], this.values[o + 2]);
            }
            case 4: {
                return new DoubleArrayValue4(this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3]);
            }
            case 5: {
                return new DoubleArrayValue5(this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4]);
            }
            case 6: {
                return new DoubleArrayValue6(this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4], this.values[o + 5]);
            }
            case 7: {
                return new DoubleArrayValue7(this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4], this.values[o + 5], this.values[o + 6]);
            }
            case 8: {
                return new DoubleArrayValue8(this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4], this.values[o + 5], this.values[o + 6], this.values[o + 7]);
            }
        }
        double[] v = new double[l];
        System.arraycopy(this.values, o, v, 0, l);
        return new UnsafeDoubleArrayValue(v);
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
        if (dest instanceof UnsafeDoubleArrayValue) {
            UnsafeDoubleArrayValue that = (UnsafeDoubleArrayValue)dest;
            System.arraycopy(this.values, (int)srcOfs, that.values, (int)destOfs, (int)len);
        } else if (destOfs < srcOfs) {
            for (long i = 0L; i < len; ++i) {
                dest.setDouble(destOfs + i, this.getDouble(srcOfs + i));
            }
        } else {
            for (long i = len - 1L; i >= 0L; --i) {
                dest.setDouble(destOfs + i, this.getDouble(srcOfs + i));
            }
        }
    }

    public int hashCode() {
        int res = 0;
        int len = Math.min(32, this.values.length);
        for (int i = 0; i < len; ++i) {
            res += (int)Double.doubleToRawLongBits(this.values[i]);
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnsafeDoubleArrayValue) {
            UnsafeDoubleArrayValue that = (UnsafeDoubleArrayValue)obj;
            return Arrays.equals(this.values, that.values);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UnsafeDoubleArrayValue(");
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.values[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void setParent(BlockValue b) {
        assert (false) : "setParent(BlockValue) called on an instance of " + this.getClass();
    }

    @Override
    public BlockValue getParent() {
        assert (false) : "getParent() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public CustomOperations getCustomOperations() {
        assert (false) : "getCustomOperations() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Object asCustom() {
        assert (false) : "asCustom() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setCustom(Object o) {
        assert (false) : "setCustom(Object) called on an instance of " + this.getClass();
    }

    @Override
    public int asInt32() {
        assert (false) : "asInt32() called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setInt32(int v) {
        assert (false) : "setInt32(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asInt64() {
        assert (false) : "asInt64() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setInt64(long v) {
        assert (false) : "setInt64(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asNativeInt() {
        assert (false) : "asNativeInt() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setNativeInt(long v) {
        assert (false) : "setNativeInt(long) called on an instance of " + this.getClass();
    }

    @Override
    public int asCastedInt() {
        return -1;
    }

    @Override
    public int asBoundedInt() throws Fatal.Exception {
        return -1;
    }

    @Override
    public long getCode() {
        assert (this.getTag() == 247 || this.getTag() == 249) : "getCode() called on an instance of " + this.getClass();
        return this.get0().asCodeOffset();
    }

    @Override
    public void setCode(long code) {
        assert (this.getTag() == 247 || this.getTag() == 249) : "setCode(long) called on an instance of " + this.getClass();
        this.set0(Value.createCodeOffset(code));
    }

    @Override
    public double asDouble() {
        assert (false) : "asDouble() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setDouble(double d) {
        assert (false) : "setDouble(double) called on an instance of " + this.getClass();
    }

    @Override
    public Value getWeak(long i) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getWeak(long) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setWeak(long i, Value v) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setWeak(long, Value) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeWeakValues() {
        assert (false) : "sizeWeakValues() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytes() {
        assert (false) : "sizeBytes() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytesTagged() {
        assert (false) : "sizeBytesTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytesMinusOneTagged() {
        assert (false) : "sizeBytesMinusOneTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public Value sizeBytesWrapped() {
        assert (false) : "sizeBytesWrapped() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public String asString() {
        assert (false) : "asString() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public byte[] getBytes() {
        assert (false) : "getBytes() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public byte[] getBytesForModification() {
        assert (false) : "getBytesForModification() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public int[] getUnsignedBytes() {
        assert (false) : "getUnsignedBytes() called on an instance of " + this.getClass();
        return new int[0];
    }

    @Override
    public byte getByte(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setByte(long idx, byte x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setByte(long, byte) called on an instance of " + this.getClass();
    }

    @Override
    public int getUnsignedByte(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getUnsignedByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setUnsignedByte(long idx, int x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setUnsignedByte(long, int) called on an instance of " + this.getClass();
    }

    @Override
    public void set(Value x, long idx) throws ArrayIndexOutOfBoundsException {
        assert (x != null) : "null x";
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + idx * (long)Unsafe.ARRAY_DOUBLE_INDEX_SCALE, x.asDouble());
    }

    @Override
    public long sizeLongs() {
        return this.values.length;
    }

    @Override
    public void setRawLong(int idx, long x) throws ArrayIndexOutOfBoundsException {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(idx * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public void setRawLong(long idx, long x) throws ArrayIndexOutOfBoundsException {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + idx * (long)Unsafe.ARRAY_DOUBLE_INDEX_SCALE, x);
    }

    @Override
    public long getRawLong(int idx) throws ArrayIndexOutOfBoundsException {
        return (long)UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(idx * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public long getRawLong(long idx) throws ArrayIndexOutOfBoundsException {
        return (long)UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + idx * (long)Unsafe.ARRAY_DOUBLE_INDEX_SCALE);
    }

    @Override
    public Value get(int idx) throws ArrayIndexOutOfBoundsException {
        return Value.createDouble(UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(idx * Unsafe.ARRAY_DOUBLE_INDEX_SCALE)));
    }

    @Override
    public Value get(long idx) throws ArrayIndexOutOfBoundsException {
        return Value.createDouble(UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + idx * (long)Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public void set(int idx, Value x) throws ArrayIndexOutOfBoundsException {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(idx * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x.asDouble());
    }

    @Override
    public void set(long idx, Value x) throws ArrayIndexOutOfBoundsException {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + idx * (long)Unsafe.ARRAY_DOUBLE_INDEX_SCALE, x.asDouble());
    }

    @Override
    public double getGenericDouble(int idx) throws ArrayIndexOutOfBoundsException {
        return UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(idx * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public double getGenericDouble(long idx) throws ArrayIndexOutOfBoundsException {
        return UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + idx * (long)Unsafe.ARRAY_DOUBLE_INDEX_SCALE);
    }

    @Override
    public void setGenericDouble(int idx, double x) throws ArrayIndexOutOfBoundsException {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(idx * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public void setGenericDouble(long idx, double x) throws ArrayIndexOutOfBoundsException {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + idx * (long)Unsafe.ARRAY_DOUBLE_INDEX_SCALE, x);
    }

    @Override
    public void setRawLong0(long x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(0 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public long getRawLong0() {
        return (long)UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(0 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public void set0(Value x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(0 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x.asDouble());
    }

    @Override
    public Value get0() {
        return Value.createDouble(UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(0 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE)));
    }

    @Override
    public void setGenericDouble0(double x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(0 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public double getGenericDouble0() {
        return UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(0 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public void setRawLong1(long x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(1 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public long getRawLong1() {
        return (long)UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(1 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public void set1(Value x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(1 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x.asDouble());
    }

    @Override
    public Value get1() {
        return Value.createDouble(UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(1 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE)));
    }

    @Override
    public void setGenericDouble1(double x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(1 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public double getGenericDouble1() {
        return UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(1 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public void setRawLong2(long x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(2 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public long getRawLong2() {
        return (long)UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(2 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public void set2(Value x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(2 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x.asDouble());
    }

    @Override
    public Value get2() {
        return Value.createDouble(UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(2 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE)));
    }

    @Override
    public void setGenericDouble2(double x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(2 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public double getGenericDouble2() {
        return UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(2 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public void setRawLong3(long x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(3 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public long getRawLong3() {
        return (long)UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(3 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public void set3(Value x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(3 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x.asDouble());
    }

    @Override
    public Value get3() {
        return Value.createDouble(UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(3 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE)));
    }

    @Override
    public void setGenericDouble3(double x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(3 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public double getGenericDouble3() {
        return UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(3 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public void setRawLong4(long x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(4 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public long getRawLong4() {
        return (long)UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(4 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public void set4(Value x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(4 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x.asDouble());
    }

    @Override
    public Value get4() {
        return Value.createDouble(UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(4 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE)));
    }

    @Override
    public void setGenericDouble4(double x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(4 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public double getGenericDouble4() {
        return UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(4 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public void setRawLong5(long x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(5 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public long getRawLong5() {
        return (long)UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(5 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public void set5(Value x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(5 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x.asDouble());
    }

    @Override
    public Value get5() {
        return Value.createDouble(UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(5 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE)));
    }

    @Override
    public void setGenericDouble5(double x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(5 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public double getGenericDouble5() {
        return UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(5 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public void setRawLong6(long x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(6 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public long getRawLong6() {
        return (long)UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(6 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public void set6(Value x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(6 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x.asDouble());
    }

    @Override
    public Value get6() {
        return Value.createDouble(UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(6 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE)));
    }

    @Override
    public void setGenericDouble6(double x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(6 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public double getGenericDouble6() {
        return UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(6 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public void setRawLong7(long x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(7 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public long getRawLong7() {
        return (long)UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(7 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }

    @Override
    public void set7(Value x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(7 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x.asDouble());
    }

    @Override
    public Value get7() {
        return Value.createDouble(UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(7 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE)));
    }

    @Override
    public void setGenericDouble7(double x) {
        UNSAFE.putDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(7 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE), x);
    }

    @Override
    public double getGenericDouble7() {
        return UNSAFE.getDouble(this.values, (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)(7 * Unsafe.ARRAY_DOUBLE_INDEX_SCALE));
    }
}

