/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import org.ocamljava.runtime.values.Value;
import org.ocamljava.runtime.wrappers.OCamlUnit;
import org.ocamljava.runtime.wrappers.OCamlValue;
import org.ocamljava.runtime.wrappers.SimpleWrapper;
import org.ocamljava.runtime.wrappers.Wrapper;

public final class OCamlBool
extends OCamlValue {
    public static final Wrapper<OCamlBool> WRAPPER = new SimpleWrapper<OCamlBool>(){

        @Override
        public OCamlBool wrap(Value value) {
            return value == Value.FALSE ? FALSE : TRUE;
        }
    };
    public static final OCamlBool TRUE = new OCamlBool(Value.TRUE);
    public static final OCamlBool FALSE = new OCamlBool(Value.FALSE);

    private OCamlBool(Value value) {
        super(value);
    }

    public Wrapper<? extends OCamlBool> getWrapper() {
        return WRAPPER;
    }

    @Override
    public Wrapper<? extends OCamlValue> getWrapper(int n) {
        return OCamlUnit.WRAPPER;
    }

    public boolean booleanValue() {
        return this.value != Value.FALSE;
    }

    @Override
    public int hashCode() {
        return this.value == Value.FALSE ? 0 : 1;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OCamlBool) {
            OCamlBool oCamlBool = (OCamlBool)object;
            return this.value == oCamlBool.value;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OCamlBool(");
        stringBuilder.append(this.value == Value.FALSE ? "false" : "true");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static OCamlBool create(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static OCamlBool wrap(Value value) {
        assert (value != null) : "null v";
        return value == Value.FALSE ? FALSE : TRUE;
    }

    public static Wrapper<? extends OCamlBool> wrapper() {
        return WRAPPER;
    }
}

