/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.ocamljava.runtime.kernel.CodeRunner;

public final class OCamlJavaThread
extends Thread {
    private static final String INTERP_THREAD_GROUP_PREFIX = "OCaml-Java-Bytecode-";
    private static final String NATIVE_THREAD_GROUP_PREFIX = "OCaml-Java-Native-";
    private static final AtomicInteger NEXT_GROUP_ID = new AtomicInteger();
    private static final String THREAD_PREFIX = "OCaml-Java-Thread-";
    private static final AtomicInteger NEXT_THREAD_ID = new AtomicInteger();
    private static final Map<Thread, CodeRunner> RUNNERS = Collections.synchronizedMap(new HashMap());
    private static final ThreadLocal<CodeRunner> CURRENT_RUNNER = new ThreadLocal<CodeRunner>(){

        @Override
        protected CodeRunner initialValue() {
            CodeRunner codeRunner = (CodeRunner)RUNNERS.get(Thread.currentThread());
            if (codeRunner != null) {
                return codeRunner;
            }
            if (RUNNERS.size() == 1) {
                return (CodeRunner)RUNNERS.values().iterator().next();
            }
            return null;
        }
    };
    private final CodeRunner runner;
    private boolean paused;

    public OCamlJavaThread(ThreadGroup threadGroup, CodeRunner codeRunner) {
        super(threadGroup, codeRunner, OCamlJavaThread.getNextName());
        assert (threadGroup != null) : "null group";
        assert (codeRunner != null) : "null run";
        this.runner = codeRunner;
        this.paused = false;
        RUNNERS.put(this, codeRunner);
    }

    public OCamlJavaThread(ThreadGroup threadGroup, String string, CodeRunner codeRunner) {
        super(threadGroup, codeRunner, string);
        assert (codeRunner != null) : "null run";
        assert (string != null) : "null name";
        this.runner = codeRunner;
        this.paused = false;
        RUNNERS.put(this, codeRunner);
    }

    public static void registerCodeRunner(Thread thread, CodeRunner codeRunner) {
        assert (thread != null) : "null t";
        assert (codeRunner != null) : "null runner";
        RUNNERS.put(thread, codeRunner);
    }

    public static boolean isRegistered(Thread thread) {
        assert (thread != null) : "null t";
        return RUNNERS.get(thread) != null;
    }

    public static CodeRunner getCodeRunner() {
        return CURRENT_RUNNER.get();
    }

    public CodeRunner getRunner() {
        return this.runner;
    }

    public void pause() {
        this.paused = true;
        super.suspend();
    }

    public void wakeUp() {
        this.paused = false;
        super.resume();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void asksToStop() {
        try {
            super.stop();
        }
        catch (ThreadDeath threadDeath) {
            // empty catch block
        }
    }

    public static String getNextThreadGroupName(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(bl ? NATIVE_THREAD_GROUP_PREFIX : INTERP_THREAD_GROUP_PREFIX);
        stringBuilder.append(NEXT_GROUP_ID.getAndIncrement());
        return stringBuilder.toString();
    }

    private static String getNextName() {
        StringBuilder stringBuilder = new StringBuilder(THREAD_PREFIX);
        stringBuilder.append(NEXT_THREAD_ID.getAndIncrement());
        return stringBuilder.toString();
    }
}

