/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class TextureParameter
extends CanvasParameter {
    private static String name = "texture";
    private static TexturePaint defValue = null;
    private String newName = "";
    private TexturePaint newValue = null;

    public String getName() {
        return name;
    }

    public String getDefault() {
        return "";
    }

    public boolean isParameterLabel(String s) {
        return s.length() > 3 && "-texture".startsWith(s);
    }

    public static TexturePaint getFromImage(Interp interp, TclObject arg) throws TclException {
        ImageIcon image = SwankUtil.getImageIcon(interp, arg);
        if (image == null) {
            throw new TclException(interp, "image \"" + arg.toString() + "\" doesn't exist");
        }
        BufferedImage bufferedImage = new BufferedImage(image.getIconWidth(), image.getIconHeight(), 1);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(image.getImage(), 0, 0, image.getIconWidth(), image.getIconHeight(), null);
        Rectangle2D.Double tR = new Rectangle2D.Double(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight());
        return new TexturePaint(bufferedImage, tR);
    }

    public TclObject getValue(Interp interp, SwkShape swkShape) throws TclException {
        if (swkShape == null) {
            throw new TclException(interp, "shape doesn't exist");
        }
        return TclString.newInstance((String)swkShape.imageName);
    }

    public void setValue(Interp interp, SwkImageCanvas swkCanvas, TclObject arg) throws TclException {
        this.newName = arg.toString();
        this.newValue = this.newName.equals("") ? null : TextureParameter.getFromImage(interp, arg);
    }

    public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
        if (swkShape.shape != null) {
            swkShape.imageName = this.newName;
            swkShape.texturePaint = this.newValue;
        }
    }
}

