/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import tcl.lang.Interp;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;

public class ShearParameter
extends CanvasParameter {
    private static String name = "shear";
    private static String defValue = "0.0 0.0";
    private float xShear = 0.0f;
    private float yShear = 0.0f;

    public String getName() {
        return name;
    }

    public String getDefault() {
        return defValue;
    }

    public boolean isParameterLabel(String s) {
        return s.length() > 3 && "-shear".startsWith(s);
    }

    public TclObject getValue(Interp interp, SwkShape swkShape) throws TclException {
        if (swkShape == null) {
            throw new TclException(interp, "shape doesn't exist");
        }
        TclObject list = TclList.newInstance();
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)swkShape.xShear));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)swkShape.yShear));
        return list;
    }

    public void setValue(Interp interp, SwkImageCanvas swkCanvas, TclObject arg) throws TclException {
        TclObject[] shearList = TclList.getElements((Interp)interp, (TclObject)arg);
        if (shearList.length != 2) {
            throw new TclException(interp, "bad shear value, must be \"xShear yShear\"");
        }
        this.xShear = (float)TclDouble.get((Interp)interp, (TclObject)shearList[0]);
        this.yShear = (float)TclDouble.get((Interp)interp, (TclObject)shearList[1]);
    }

    public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
        if (swkShape != null) {
            swkShape.xShear = this.xShear;
            swkShape.yShear = this.yShear;
            swkShape.newTransform = true;
        }
    }
}

