/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class SwkExceptionCmd {
    public static void doExceptionCmd(Interp interp, String cmd) throws TclException {
        interp.allowExceptions();
        try {
            interp.eval(cmd);
        }
        catch (TclException tclE) {
            throw new TclException(interp, tclE.getMessage(), tclE.getCompletionCode());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TclException(interp, "Error executing:\n" + cmd + "\n" + e.getMessage());
        }
    }

    public static void doExceptionCmdBG(Interp interp, String cmd) {
        interp.allowExceptions();
        try {
            interp.eval(cmd);
        }
        catch (TclException tclE) {
            if (tclE.getCompletionCode() == 3) {
                return;
            }
            System.out.println("throw " + tclE.toString());
            interp.addErrorInfo(tclE.getMessage());
            interp.backgroundError();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("except in CmdBG" + e.getMessage());
            interp.addErrorInfo(e.getMessage());
            interp.backgroundError();
        }
    }

    public static void setVar(Interp interp, String var1, String var2, double value) {
        TclObject tObj = TclDouble.newInstance((double)value);
        SwkExceptionCmd.setVar(interp, var1, var2, tObj);
    }

    public static void setVar(Interp interp, String var1, String var2, int value) {
        TclObject tObj = TclInteger.newInstance((int)value);
        SwkExceptionCmd.setVar(interp, var1, var2, tObj);
    }

    public static void setVar(Interp interp, String var1, String var2, boolean value) {
        TclObject tObj = TclBoolean.newInstance((boolean)value);
        SwkExceptionCmd.setVar(interp, var1, var2, tObj);
    }

    public static void setVar(Interp interp, String var1, String var2, String value) {
        TclObject tObj = TclString.newInstance((String)value);
        SwkExceptionCmd.setVar(interp, var1, var2, tObj);
    }

    public static void setVar(Interp interp, String var1, String var2, TclObject tObj) {
        interp.allowExceptions();
        try {
            interp.setVar(var1, var2, tObj, 1);
        }
        catch (TclException tclE) {
            if (tclE.getCompletionCode() == 3) {
                return;
            }
            System.out.println("throw " + tclE.toString());
            interp.addErrorInfo(tclE.getMessage());
            interp.backgroundError();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("except in setVarBG" + e.getMessage());
            interp.addErrorInfo(e.getMessage());
            interp.backgroundError();
        }
    }
}

