/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.canvas.SwkShape;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.BreakIterator;

public class TextParameters {
    private static final TextParameters defaultPar = new TextParameters();
    private String text = "";
    private Font font = null;
    private Color textColor = null;
    private float[] anchor = new float[]{0.0f, 0.0f};
    static BreakIterator wordIterator = BreakIterator.getWordInstance();
    int[] ends = null;

    static TextParameters getDefault() {
        return defaultPar;
    }

    public String getText() {
        return this.text;
    }

    public static TextParameters setText(TextParameters strokePar, String newValue) {
        if (!newValue.equals(strokePar.text)) {
            if (strokePar == defaultPar) {
                strokePar = new TextParameters();
            }
            strokePar.text = newValue;
        }
        return strokePar;
    }

    public Font getFont() {
        return this.font;
    }

    public static TextParameters setFont(TextParameters strokePar, Font newValue) {
        if (!newValue.equals(strokePar.font)) {
            if (strokePar == defaultPar) {
                strokePar = new TextParameters();
            }
            strokePar.font = newValue;
        }
        return strokePar;
    }

    public Color getTextColor() {
        if (this.textColor == null) {
            return Color.BLACK;
        }
        return this.textColor;
    }

    public static TextParameters setTextColor(TextParameters strokePar, Color newValue) {
        if (!newValue.equals(strokePar.textColor)) {
            if (strokePar == defaultPar) {
                strokePar = new TextParameters();
            }
            strokePar.textColor = newValue;
        }
        return strokePar;
    }

    public float[] getAnchor() {
        return this.anchor;
    }

    public static TextParameters setAnchor(TextParameters strokePar, float[] newValue) {
        boolean change = false;
        if (newValue.length != strokePar.anchor.length) {
            change = true;
        } else {
            for (int i = 0; i < newValue.length; ++i) {
                if (newValue[i] == strokePar.anchor[i]) continue;
                change = true;
                break;
            }
        }
        if (change) {
            if (strokePar == defaultPar) {
                strokePar = new TextParameters();
            }
            strokePar.anchor[0] = newValue[0];
            strokePar.anchor[1] = newValue[1];
        }
        return strokePar;
    }

    int getLineBreaks(FontRenderContext fRC, Font font, String text, float width) {
        float width1 = (float)font.getStringBounds(text, fRC).getWidth();
        int iEnd = 1;
        if (text.indexOf(10) != -1) {
            int i;
            int nNewLines = 0;
            for (i = 0; i < text.length(); ++i) {
                if (text.charAt(i) != '\n') continue;
                ++nNewLines;
            }
            this.ends = new int[nNewLines + 2];
            this.ends[0] = 0;
            for (i = 0; i < text.length(); ++i) {
                if (text.charAt(i) != '\n') continue;
                this.ends[iEnd++] = i;
            }
            this.ends[iEnd] = text.length();
            return iEnd;
        }
        if (width != 0.0f && width1 > width) {
            int start = 0;
            int guessSize = (int)(width1 * 2.0f / width) + 1;
            if (this.ends == null || this.ends.length < guessSize) {
                this.ends = new int[guessSize];
            }
            this.ends[0] = 0;
            wordIterator.setText(text);
            start = wordIterator.first();
            int okEnd = text.length();
            boolean gotAnEnd = false;
            int end = wordIterator.next();
            while (end != -1) {
                width1 = (float)font.getStringBounds(text.substring(start, end), fRC).getWidth();
                if (width1 < width) {
                    this.ends[iEnd] = okEnd = end;
                    gotAnEnd = true;
                } else if (gotAnEnd) {
                    start = okEnd;
                    this.ends[++iEnd] = okEnd = end;
                    gotAnEnd = true;
                }
                end = wordIterator.next();
            }
        }
        return iEnd;
    }

    public Rectangle2D paint(Graphics2D g2, FontRenderContext fRC, SwkShape swkShape, double x, double y) {
        Font paintFont = g2.getFont();
        if (this.getFont() != null) {
            paintFont = this.getFont();
            g2.setFont(paintFont);
        }
        g2.setPaint(this.getTextColor());
        String text = this.getText();
        Rectangle2D rf1d = null;
        if (text == null || text.equals("")) {
            return new Rectangle2D.Float((float)x, (float)y, 1.0f, 1.0f);
        }
        int nLines = this.getLineBreaks(fRC, paintFont, text, swkShape.width);
        String textLine = text;
        float width2 = 0.0f;
        Point2D point2D = new Point2D.Double(x, y);
        Rectangle2D.Double unionRect = new Rectangle2D.Double();
        AffineTransform shapeTransform = swkShape.getTransform();
        if (shapeTransform != null) {
            point2D = shapeTransform.transform(point2D, point2D);
        }
        x = (int)point2D.getX();
        y = (int)point2D.getY();
        for (int i = 0; i < nLines; ++i) {
            if (nLines > 1) {
                textLine = text.substring(this.ends[i], this.ends[i + 1]).trim();
            }
            float width1 = (float)paintFont.getStringBounds(textLine, fRC).getWidth();
            float height1 = (float)paintFont.getStringBounds(textLine, fRC).getHeight();
            if (i == 0) {
                width2 = width1 * this.getAnchor()[1];
            }
            float height2 = height1 * this.getAnchor()[0];
            AffineTransform aT = new AffineTransform();
            aT.rotate(swkShape.rotate, x, y);
            Rectangle2D.Double rf2 = new Rectangle2D.Double(x - (double)width2, y + (double)height2, 0.0, 0.0);
            Rectangle2D rf2D = aT.createTransformedShape(rf2).getBounds2D();
            Rectangle2D.Double rf1 = new Rectangle2D.Double((float)(x - (double)width2), (float)(y - (double)height1 + (double)height2), width1, height1);
            rf1d = aT.createTransformedShape(rf1).getBounds2D();
            if (i == 0) {
                ((Rectangle2D)unionRect).setRect(rf1d);
            } else {
                Rectangle2D.union(rf1d, unionRect, unionRect);
            }
            if ((double)swkShape.rotate != 0.0) {
                g2.rotate(swkShape.rotate, rf2D.getX(), rf2D.getY());
            }
            if (textLine != null) {
                g2.drawString(textLine, (int)rf2D.getX(), (int)rf2D.getY());
            }
            if ((double)swkShape.rotate != 0.0) {
                g2.rotate(-swkShape.rotate, rf2D.getX(), rf2D.getY());
            }
            y += (double)height1;
        }
        return unionRect;
    }
}

