/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import java.util.ArrayList;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;

public class TagsParameter
extends CanvasParameter {
    private static String name = "tags";
    private static String defValue = "";
    private String[] newValue = null;

    public String getName() {
        return name;
    }

    public String getDefault() {
        return defValue;
    }

    public boolean isParameterLabel(String s) {
        return s.length() > 3 && "-tags".startsWith(s);
    }

    public TclObject getValue(Interp interp, SwkShape swkShape) throws TclException {
        if (swkShape == null) {
            throw new TclException(interp, "shape doesn't exist");
        }
        ArrayList aList = swkShape.canvas.getTags(swkShape);
        return SwankUtil.arrayToList(interp, aList);
    }

    public void setValue(Interp interp, SwkImageCanvas swkCanvas, TclObject arg) throws TclException {
        TclObject[] tagList = TclList.getElements((Interp)interp, (TclObject)arg);
        this.newValue = SwankUtil.argvToStrings(tagList, 0);
    }

    public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
        if (swkShape != null) {
            swkShape.setTags(this.newValue);
            try {
                swkCanvas.setTags(swkShape.tagNames, swkShape);
            }
            catch (SwkException swkException) {
                // empty catch block
            }
        }
    }
}

