/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import tcl.lang.Interp;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class SwkTableModel
extends AbstractTableModel
implements TableModelListener {
    private static final int DEFAULT = 0;
    private static final int DATE = 1;
    private static final int INT = 2;
    private static final int ROWS = 0;
    private static final int COLUMNS = 1;
    private static final int HEADER = 2;
    private static final int GET = 3;
    private static final int SET = 4;
    String[] modes = new String[]{"rows", "columns", "header", "get", "set"};
    Interp interp = null;
    public String command = null;
    public String variable = null;
    public boolean useCommand = false;
    public boolean tableEditable = true;
    Hashtable colTable = new Hashtable();
    SimpleDateFormat dateFormat = null;
    private int nRows = 0;
    private int nCols = 0;
    Vector sortingColumns = new Vector();
    boolean ascending = true;
    int compares;
    private int sortMode;
    protected SwkTableModel model;
    ArrayList columnArrays = new ArrayList();
    ArrayList headers = new ArrayList();

    public SwkTableModel() {
    }

    public SwkTableModel(Interp interp) {
        this.interp = interp;
        this.command = "";
        for (int i = 0; i < this.getNCols(); ++i) {
            ArrayList colList = new ArrayList();
            colList.ensureCapacity(this.getNRows());
            this.columnArrays.add(colList);
            this.headers.add(String.valueOf(i));
        }
    }

    public synchronized int getNRows() {
        return this.nRows;
    }

    public synchronized void setNRows(int nRows) {
        this.nRows = nRows;
    }

    public synchronized int getNCols() {
        return this.nCols;
    }

    public synchronized void setNCols(int nCols) {
        this.nCols = nCols;
    }

    public void setInterp(Interp interp) {
        this.interp = interp;
    }

    public Interp getInterp() {
        return this.interp;
    }

    public SwkTableModel getModel() {
        return this.model;
    }

    public void setModel(SwkTableModel model) {
        this.model = model;
    }

    public void setCommand(String command) {
        this.command = command.intern();
        this.useCommand = true;
    }

    String getCommand() {
        return this.command;
    }

    void setUseCommand(boolean useCommand) {
        this.command = this.command.intern();
        this.useCommand = useCommand;
    }

    boolean getUseCommand() {
        return this.useCommand;
    }

    void setVariable(String variable) {
        this.variable = variable.intern();
        this.useCommand = false;
    }

    String getVariable() {
        return this.variable;
    }

    void setEditable(boolean state) {
        this.tableEditable = state;
    }

    boolean isEditable() {
        return this.tableEditable;
    }

    public void setColumnClass(Interp interp, int c, Class colClass) {
        this.colTable.put(new Integer(c), colClass);
        this.tableChanged(new TableModelEvent(this));
    }

    public Class getColumnClass(int c) {
        Class colClass = (Class)this.colTable.get(new Integer(c));
        if (colClass != null) {
            return colClass;
        }
        return "".getClass();
    }

    public int getRowCount() {
        if (this.useCommand && this.command != null && !this.command.equals("")) {
            this.doCommand(this.interp, this.command, 0, 0, 0, null);
        }
        return this.getNRows();
    }

    public int getColumnCount() {
        if (this.useCommand && this.command != null && !this.command.equals("")) {
            this.doCommand(this.interp, this.command, 1, 0, 0, null);
        }
        return this.getNCols();
    }

    public boolean isCellEditable(int row, int col) {
        return this.tableEditable;
    }

    public void setValueAt(Object value, int row, int col) {
        if (this.useCommand) {
            if (this.command == null || this.command.equals("")) {
                return;
            }
            this.doCommand(this.interp, this.command, 4, row, col, value);
        } else if (this.variable != null && !this.variable.equals("")) {
            TclObject tobj = null;
            tobj = value instanceof TclObject ? (TclObject)value : TclString.newInstance((String)value.toString());
            try {
                this.interp.setVar(this.variable, row + "," + col, tobj, 1);
                this.fireTableCellUpdatedET(row, col);
            }
            catch (TclException tclE) {
                // empty catch block
            }
        }
    }

    public Object getValueAt(int row, int col) {
        if (this.useCommand) {
            if (this.command == null || this.command.equals("")) {
                return "";
            }
            ArrayList cList = (ArrayList)this.columnArrays.get(col);
            String value = "nu";
            if (cList.size() > row) {
                value = cList.get(row);
            }
            this.doCommand(this.interp, this.command, 3, row, col, null);
            return value;
        }
        if (this.variable != null && !this.variable.equals("")) {
            try {
                TclObject tobj = this.interp.getVar(this.variable, row + "," + col, 1);
                return tobj.toString();
            }
            catch (TclException tclE) {
                return "";
            }
        }
        return "";
    }

    void checkColumns() {
        int i;
        int nCols = this.getNCols();
        for (i = this.columnArrays.size(); i <= nCols; ++i) {
            this.columnArrays.add(new ArrayList());
        }
        for (i = this.headers.size(); i <= nCols; ++i) {
            this.headers.add(String.valueOf(i));
        }
    }

    public String getColumnName(int col) {
        if (this.useCommand) {
            if (this.command == null || this.command.equals("")) {
                return Integer.toString(col);
            }
            this.checkColumns();
            this.doCommand(this.interp, this.command, 2, 0, col, null);
            return (String)this.headers.get(col);
        }
        if (this.variable != null && !this.variable.equals("")) {
            try {
                TclObject tobj = this.interp.getVar(this.variable, "-1," + col, 1);
                return tobj.toString();
            }
            catch (TclException tclE) {
                return Integer.toString(col);
            }
        }
        return Integer.toString(col);
    }

    public void doCommand(Interp interp, String command, int mode, int row, int col, Object value) {
        StringBuffer sbuf = new StringBuffer();
        block8: for (int i = 0; i < command.length(); ++i) {
            if (command.charAt(i) != '%') {
                sbuf.append(command.charAt(i));
                continue;
            }
            char type = command.charAt(++i);
            switch (type) {
                case 'c': {
                    sbuf.append(Integer.toString(col));
                    continue block8;
                }
                case 'r': {
                    sbuf.append(Integer.toString(row));
                    continue block8;
                }
                case 'C': {
                    sbuf.append(Integer.toString(row));
                    sbuf.append(",");
                    sbuf.append(Integer.toString(col));
                    continue block8;
                }
                case 'i': {
                    sbuf.append(Integer.toString(mode));
                    continue block8;
                }
                case 'm': {
                    sbuf.append(this.modes[mode]);
                    continue block8;
                }
                case 's': {
                    if (value != null) {
                        sbuf.append(value.toString());
                        continue block8;
                    }
                    sbuf.append("{}");
                }
            }
        }
        if (mode < 2) {
            // empty if block
        }
        SwkTableEvent bEvent = new SwkTableEvent(interp, mode, row, col, sbuf.toString());
        bEvent.invokeLater();
    }

    public void tableChanged(TableModelEvent e) {
        this.fireTableChanged(e);
    }

    static boolean getBoolean(Interp interp, String string) throws TclException {
        String s = string.toLowerCase();
        if (s.length() > 0) {
            if ("yes".startsWith(s)) {
                return true;
            }
            if ("no".startsWith(s)) {
                return false;
            }
            if ("true".startsWith(s)) {
                return true;
            }
            if ("false".startsWith(s)) {
                return false;
            }
            if ("on".startsWith(s) && s.length() > 1) {
                return true;
            }
            if ("off".startsWith(s) && s.length() > 1) {
                return false;
            }
            if (s.equals("0")) {
                return false;
            }
            if (s.equals("1")) {
                return true;
            }
        }
        throw new TclException(interp, "expected boolean value but got \"" + string + "\"");
    }

    void fireTableStructureChangedET() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwkTableModel.this.fireTableStructureChanged();
            }
        });
    }

    void fireTableCellUpdatedET(final int row, final int col) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwkTableModel.this.fireTableCellUpdated(row, col);
            }
        });
    }

    class SwkTableEvent
    extends TclEvent {
        Interp interp = null;
        String cmd = null;
        int mode = 0;
        int row = 0;
        int col = 0;

        public SwkTableEvent(Interp interp, int mode, int row, int col, String cmd) {
            this.interp = interp;
            this.row = row;
            this.col = col;
            this.mode = mode;
            this.cmd = cmd.intern();
        }

        public int processEvent(int flags) {
            if (this.interp != null && this.cmd != null) {
                TclObject tObj = null;
                try {
                    this.interp.eval(this.cmd);
                    tObj = this.interp.getResult();
                    if (this.mode == 0) {
                        int n = TclInteger.get((Interp)this.interp, (TclObject)tObj);
                        if (SwkTableModel.this.getNRows() != n) {
                            SwkTableModel.this.setNRows(n);
                            SwkTableModel.this.fireTableStructureChangedET();
                        }
                    } else if (this.mode == 1) {
                        int n = TclInteger.get((Interp)this.interp, (TclObject)tObj);
                        if (SwkTableModel.this.getNCols() != n) {
                            SwkTableModel.this.setNCols(n);
                            SwkTableModel.this.fireTableStructureChangedET();
                        }
                    } else if (this.mode == 2) {
                        String headerVal = tObj.toString();
                        if (!((String)SwkTableModel.this.headers.get(this.col)).equals(headerVal)) {
                            SwkTableModel.this.headers.set(this.col, headerVal);
                            SwkTableModel.this.fireTableStructureChangedET();
                        }
                    } else if (this.mode == 3 && this.row >= 0) {
                        ArrayList cList = (ArrayList)SwkTableModel.this.columnArrays.get(this.col);
                        for (int i = cList.size(); i <= this.row; ++i) {
                            cList.add("duck");
                        }
                        if (!tObj.toString().equals((String)cList.get(this.row))) {
                            cList.set(this.row, tObj.toString());
                            SwkTableModel.this.fireTableCellUpdatedET(this.row, this.col);
                        }
                    }
                }
                catch (TclException tE) {
                    this.interp.backgroundError();
                    System.out.println(tE.getMessage());
                }
            }
            return 1;
        }

        public void invokeLater() {
            this.interp.getNotifier().queueEvent((TclEvent)this, 0);
        }

        public void invokeAndWait() {
            this.interp.getNotifier().queueEvent((TclEvent)this, 0);
            this.sync();
        }
    }
}

