/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.SwkJSlider;
import com.onemoonscientific.swank.UpdateOnEventThread;
import com.onemoonscientific.swank.Widgets;
import java.awt.Dimension;
import java.awt.Point;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class SwkJSliderWidgetCmd
implements Command {
    private static final String[] validCmds = new String[]{"cget", "configure", "coords", "get", "identify", "set"};
    private static final int OPT_CGET = 0;
    private static final int OPT_CONFIGURE = 1;
    private static final int OPT_COORDS = 2;
    private static final int OPT_GET = 3;
    private static final int OPT_IDENTIFY = 4;
    private static final int OPT_SET = 5;
    static boolean gotDefaults = false;

    SwkJSliderWidgetCmd() {
    }

    public static String[] getValidCmds() {
        return validCmds;
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        TclObject tObj = (TclObject)Widgets.getWidget(interp, argv[0].toString());
        if (tObj == null) {
            throw new TclException(interp, "bad window path name \"" + argv[0].toString() + "\"");
        }
        SwkJSlider swkjslider = (SwkJSlider)ReflectObject.get((Interp)interp, (TclObject)tObj);
        switch (opt) {
            case 0: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                interp.setResult(swkjslider.jget(interp, argv[2]));
                break;
            }
            case 1: {
                if (!gotDefaults) {
                    swkjslider.setResourceDefaults();
                    gotDefaults = true;
                }
                if (argv.length == 2) {
                    swkjslider.jgetAll(interp);
                    break;
                }
                if (argv.length == 3) {
                    String result = swkjslider.jget(interp, argv[2]);
                    ResourceObject ro = (ResourceObject)SwkJSlider.resourceDB.get(argv[2].toString());
                    if (ro == null) {
                        throw new TclException(interp, "unknown option \"" + argv[2].toString() + "\"");
                    }
                    TclObject list = TclList.newInstance();
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)argv[2].toString()));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.resource));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.className));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.defaultVal));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)result));
                    interp.setResult(list);
                    break;
                }
                swkjslider.configure(interp, argv, 2);
                break;
            }
            case 2: {
                this.coords(interp, swkjslider, argv);
                break;
            }
            case 3: {
                this.get(interp, swkjslider, argv);
                break;
            }
            case 4: {
                this.identify(interp, swkjslider, argv);
                break;
            }
            case 5: {
                this.set(interp, swkjslider, argv);
                break;
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    void coords(Interp interp, SwkJSlider swkjslider, TclObject[] argv) throws TclException {
        if (argv.length != 2) {
            throw new TclNumArgsException(interp, 2, argv, "");
        }
        double value = 0.0;
        Point pt = null;
        if (argv.length == 3) {
            value = TclDouble.get((Interp)interp, (TclObject)argv[2]);
            pt = new Coords().exec(swkjslider, true, value);
        } else {
            pt = new Coords().exec(swkjslider, false, 0.0);
        }
        TclObject list = TclList.newInstance();
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)pt.x));
        TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)pt.y));
        interp.setResult(list);
    }

    void get(Interp interp, SwkJSlider swkjslider, TclObject[] argv) throws TclException {
        if (argv.length != 2 && argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "?x y?");
        }
        int x = 0;
        int y = 0;
        Object pt = null;
        TclObject result = null;
        if (argv.length == 4) {
            x = TclInteger.get((Interp)interp, (TclObject)argv[2]);
            y = TclInteger.get((Interp)interp, (TclObject)argv[3]);
            result = new Get().exec(swkjslider, true, x, y);
        } else {
            result = new Get().exec(swkjslider, false, 0, 0);
        }
        interp.setResult(result);
    }

    void identify(Interp interp, SwkJSlider swkjslider, TclObject[] argv) throws TclException {
        if (argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "x y");
        }
        int x = TclInteger.get((Interp)interp, (TclObject)argv[2]);
        int y = TclInteger.get((Interp)interp, (TclObject)argv[3]);
    }

    void set(Interp interp, SwkJSlider swkjslider, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "value");
        }
        double value = TclDouble.get((Interp)interp, (TclObject)argv[2]);
        new Set().exec(swkjslider, value);
    }

    class Set
    extends UpdateOnEventThread {
        SwkJSlider swkjslider = null;
        double value = 0.0;

        Set() {
        }

        void exec(SwkJSlider swkjslider, double value) {
            this.value = value;
            this.swkjslider = swkjslider;
            this.execOnThread();
        }

        public void run() {
            if (this.swkjslider.isEnabled()) {
                this.swkjslider.setDValue(this.value);
            }
        }
    }

    class Get
    extends GetValueOnEventThread {
        SwkJSlider swkjslider = null;
        int size = 0;
        int x = 0;
        int y = 0;
        boolean hasValue = false;
        Point pt = new Point();
        TclObject result = null;

        Get() {
        }

        TclObject exec(SwkJSlider swkjslider, boolean hasValue, int x, int y) {
            this.swkjslider = swkjslider;
            this.x = x;
            this.y = y;
            this.hasValue = hasValue;
            this.execOnThread();
            return this.result;
        }

        public void run() {
            if (!this.hasValue) {
                this.result = this.swkjslider.resolution >= 1.0 ? TclInteger.newInstance((int)((int)this.swkjslider.getDValue())) : TclDouble.newInstance((double)this.swkjslider.getDValue());
            } else {
                Dimension size = this.swkjslider.getSize();
                double to = this.swkjslider.getTo();
                double from = this.swkjslider.getFrom();
                int halfWid = 7;
                double value = this.swkjslider.jslider.getOrientation() == 1 ? (double)(this.y - halfWid) / (double)(size.height - halfWid) * (to - from) + from : (double)(this.x - halfWid) / (double)(size.width - halfWid) * (to - from) + from;
                if (this.swkjslider.resolution == 0.0 || this.swkjslider.resolution >= 1.0) {
                    int iValue = (int)Math.round(value);
                    this.result = TclInteger.newInstance((int)iValue);
                } else {
                    value = (double)Math.round(value / this.swkjslider.resolution) * this.swkjslider.resolution;
                    this.result = TclDouble.newInstance((double)value);
                }
            }
        }
    }

    class Coords
    extends GetValueOnEventThread {
        SwkJSlider swkjslider = null;
        int size = 0;
        double value = 0.0;
        boolean hasValue = false;
        Point pt = new Point();

        Coords() {
        }

        Point exec(SwkJSlider swkjslider, boolean hasValue, double value) {
            this.swkjslider = swkjslider;
            this.value = value;
            this.hasValue = hasValue;
            this.execOnThread();
            return this.pt;
        }

        public void run() {
            int y;
            int x;
            Dimension size = this.swkjslider.getSize();
            double to = this.swkjslider.getTo();
            double from = this.swkjslider.getFrom();
            double value = 0.0;
            if (!this.hasValue) {
                value = this.swkjslider.getDValue();
            }
            int halfWid = 7;
            if (this.swkjslider.jslider.getOrientation() == 1) {
                x = size.width / 2;
                y = (int)((value - from) / (to - from) * (double)(size.height - halfWid) + (double)halfWid);
            } else {
                x = (int)((value - from) / (to - from) * (double)(size.width - halfWid) + (double)halfWid);
                y = size.height / 2;
            }
            this.pt.x = x;
            this.pt.y = y;
        }
    }
}

