/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkJColorChooser;
import com.onemoonscientific.swank.Widgets;
import java.awt.Color;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class SwkJColorChooserWidgetCmd
implements Command {
    private static final String[] validCmds = new String[]{"configure", "cget", "choose"};
    private static final int OPT_CONFIGURE = 0;
    private static final int OPT_CGET = 1;
    private static final int OPT_CHOOSE = 2;
    static boolean gotDefaults = false;

    SwkJColorChooserWidgetCmd() {
    }

    public static String[] getValidCmds() {
        return validCmds;
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        TclObject tObj = (TclObject)Widgets.getWidget(interp, argv[0].toString());
        if (tObj == null) {
            throw new TclException(interp, "bad window path name \"" + argv[0].toString() + "\"");
        }
        SwkJColorChooser swkjcolorchooser = (SwkJColorChooser)ReflectObject.get((Interp)interp, (TclObject)tObj);
        switch (opt) {
            case 1: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                interp.setResult(swkjcolorchooser.jget(interp, argv[2]));
                break;
            }
            case 0: {
                if (!gotDefaults) {
                    swkjcolorchooser.setResourceDefaults();
                    gotDefaults = true;
                }
                if (argv.length == 2) {
                    swkjcolorchooser.jgetAll(interp);
                    break;
                }
                if (argv.length == 3) {
                    String result = swkjcolorchooser.jget(interp, argv[2]);
                    ResourceObject ro = (ResourceObject)SwkJColorChooser.resourceDB.get(argv[2].toString());
                    if (ro == null) {
                        throw new TclException(interp, "unknown option \"" + argv[2].toString() + "\"");
                    }
                    TclObject list = TclList.newInstance();
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)argv[2].toString()));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.resource));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.className));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.defaultVal));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)result));
                    interp.setResult(list);
                    break;
                }
                swkjcolorchooser.configure(interp, argv, 2);
                break;
            }
            case 2: {
                this.choose(interp, swkjcolorchooser, argv);
                break;
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    void choose(Interp interp, SwkJColorChooser swkjcolorchooser, TclObject[] argv) throws TclException {
        if (argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "title color");
        }
        Color initialColor = SwankUtil.getColor(interp, argv[3]);
        Color color = new Choose().exec(swkjcolorchooser, argv[2].toString(), initialColor);
        if (color != null) {
            interp.setResult(SwankUtil.parseColor(color));
        }
    }

    class Choose
    extends GetValueOnEventThread {
        SwkJColorChooser swkjcolorchooser;
        Color color = null;
        Color initialColor = null;
        String title = "";

        Choose() {
        }

        Color exec(SwkJColorChooser swkjcolorchooser, String title, Color initialColor) {
            this.swkjcolorchooser = swkjcolorchooser;
            this.title = title;
            this.initialColor = initialColor;
            this.execOnThread();
            return this.color;
        }

        public void run() {
            this.color = SwkJColorChooser.showDialog(this.swkjcolorchooser.getParent(), this.title, this.initialColor);
        }
    }
}

