/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.BindCmd;
import com.onemoonscientific.swank.BindEvent;
import com.onemoonscientific.swank.SwkBind;
import com.onemoonscientific.swank.SwkBinding;
import com.onemoonscientific.swank.SwkJFrame;
import com.onemoonscientific.swank.SwkListener;
import com.onemoonscientific.swank.SwkWidget;
import com.onemoonscientific.swank.Widgets;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Vector;
import tcl.lang.Interp;
import tcl.lang.TclEvent;
import tcl.lang.TclException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwkFocusListener
implements FocusListener,
SwkListener {
    Interp interp;
    String command = "puts Focus";
    Component component;
    ArrayList<SwkBinding> bindings;

    SwkFocusListener(Interp interp, Component component) {
        this.interp = interp;
        this.component = component;
        this.bindings = new ArrayList();
    }

    public ArrayList<SwkBinding> getBindings() {
        return this.bindings;
    }

    public void setCommand(String name) {
        this.command = name;
    }

    public String getCommand() {
        return this.command;
    }

    public void setBinding(SwkBinding newBinding) {
        SwkBind.setBinding(this.bindings, newBinding);
    }

    @Override
    public void focusGained(FocusEvent e) {
        BindEvent bEvent = new BindEvent(this.interp, this, e, 5);
        this.interp.getNotifier().queueEvent((TclEvent)bEvent, 0);
    }

    @Override
    public void focusLost(FocusEvent e) {
        BindEvent bEvent = new BindEvent(this.interp, this, e, 6);
        this.interp.getNotifier().queueEvent((TclEvent)bEvent, 0);
    }

    @Override
    public void processEvent(EventObject eventObject, Object obj, int subtype) {
        FocusEvent e = (FocusEvent)eventObject;
        ArrayList<SwkBinding> bindings = null;
        Vector tagList = ((SwkWidget)((Object)this.component)).getTagList();
        for (int j = 0; j < tagList.size(); ++j) {
            bindings = null;
            String tag = (String)tagList.elementAt(j);
            if (tag.equals(((SwkWidget)((Object)this.component)).getName())) {
                bindings = this.bindings;
            } else if (tag.startsWith(".")) {
                try {
                    bindings = ((SwkJFrame)Widgets.get(this.interp, tag)).getFocusListener().getBindings();
                }
                catch (TclException tclE) {}
            } else {
                bindings = BindCmd.getFocusBindings(tag);
            }
            if (bindings == null) continue;
            for (int i = 0; i < bindings.size(); ++i) {
                SwkBinding binding = bindings.get(i);
                if (binding.subtype != subtype || binding.command == null || binding.command.length() == 0) continue;
                try {
                    BindCmd.doCmd(this.interp, binding, this.component, e);
                    continue;
                }
                catch (TclException tclE) {
                    if (tclE.getCompletionCode() == 3) {
                        return;
                    }
                    this.interp.addErrorInfo("\n    (\"binding\" script)");
                    this.interp.backgroundError();
                }
            }
        }
    }
}

