/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.values.Value;

public final class OCamlWrappers {
    private static final String OID_CALLBACK = "CamlinternalOO.last_id";

    private OCamlWrappers() {
    }

    public static boolean asBool(Value value) {
        assert (value != null) : "null v";
        return value != Value.FALSE;
    }

    public static Value createBool(boolean bl) {
        return bl ? Value.TRUE : Value.FALSE;
    }

    public static Value getAndIncrementOid() {
        CodeState codeState = CurrentContext.CODE_STATE;
        Value value = codeState.getCallback(OID_CALLBACK);
        if (value == null) {
            value = Value.createBlock(0, Value.ZERO);
            codeState.registerCallback(OID_CALLBACK, value);
        }
        Value value2 = value.get0();
        value.set0(Value.createLong(value2.asLong() + 1L));
        return value2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Value createClosure(Class<?> clazz, String string, Object object, int n) {
        assert (clazz != null) : "null clazz";
        assert (string != null) : "null method";
        assert (object != null) : "null thiz";
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class[] classArray = new Class[n];
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    MethodType methodType = MethodType.methodType(Value.class, classArray);
                    MethodHandle methodHandle = lookup.findVirtual(clazz, string, methodType);
                    return Value.createClosure(methodHandle.bindTo(object), n);
                }
                classArray[n2] = Value.class;
                ++n2;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            return null;
        }
    }
}

