/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.otherlibs.graph.CustomImage;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="graph", module="Graphics", source="otherlibs/graph/image.c")
public final class Image {
    private Image() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int"}, returnType="Graphics.image")
    public static Value caml_gr_create_image(Value value, Value value2) throws Fail.Exception {
        GraphSlot.checkGraph();
        int n = value.asCastedInt();
        int n2 = value2.asCastedInt();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        return Value.createCustom(CustomImage.OPS, 16L, bufferedImage);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Graphics.image", "int", "int"}, returnType="unit")
    public static Value caml_gr_blit_image(Value value, Value value2, Value value3) throws Fail.Exception {
        GraphSlot graphSlot = GraphSlot.checkGraph();
        BufferedImage bufferedImage = graphSlot.getBuffer();
        BufferedImage bufferedImage2 = (BufferedImage)value.asCustom();
        int n = bufferedImage2.getWidth();
        int n2 = bufferedImage2.getHeight();
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((java.awt.Image)bufferedImage.getSubimage(value2.asCastedInt(), graphSlot.convertY(value3.asCastedInt()) - n2, n, n2), 0, 0, null);
        graphics2D.dispose();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Graphics.image", "int", "int"}, returnType="unit")
    public static Value caml_gr_draw_image(Value value, Value value2, Value value3) throws Fail.Exception {
        Graphics2D graphics2D;
        GraphSlot graphSlot = GraphSlot.checkGraph();
        BufferedImage bufferedImage = (BufferedImage)value.asCustom();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = value2.asCastedInt();
        int n4 = graphSlot.convertY(value3.asCastedInt()) - n2;
        Graphics2D graphics2D2 = graphSlot.createWindowGraphics();
        if (graphics2D2 != null) {
            graphics2D2.drawImage(bufferedImage, n3, n4, n, n2, null);
            graphics2D2.dispose();
            graphSlot.repaint();
        }
        if ((graphics2D = graphSlot.createBackingStoreGraphics()) != null) {
            graphics2D.drawImage(bufferedImage, n3, n4, n, n2, null);
            graphics2D.dispose();
        }
        return Value.UNIT;
    }
}

