/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.values.Value;

public final class NativeUtils {
    private NativeUtils() {
    }

    public static Value caml_array_get_addr(Value value, long l) throws Fail.Exception {
        if (l < 0L || l >= value.sizeValues()) {
            Fail.arrayBoundError();
        }
        return value.get(l);
    }

    public static double caml_array_get_float(Value value, long l) throws Fail.Exception {
        if (l < 0L || l >= value.sizeDoubles()) {
            Fail.arrayBoundError();
        }
        return value.getDouble(l);
    }

    public static long caml_array_get_int(Value value, long l) throws Fail.Exception {
        if (l < 0L || l >= value.sizeLongs()) {
            Fail.arrayBoundError();
        }
        return value.getRawLong(l);
    }

    public static Value caml_array_get(Value value, long l) throws Fail.Exception {
        if (value.isDoubleArray()) {
            return Value.createDouble(NativeUtils.caml_array_get_float(value, l));
        }
        return NativeUtils.caml_array_get_addr(value, l);
    }

    public static Value caml_array_set_addr(Value value, long l, Value value2) throws Fail.Exception {
        if (l < 0L || l >= value.sizeValues()) {
            Fail.arrayBoundError();
        }
        value.set(l, value2);
        return Value.UNIT;
    }

    public static Value caml_array_set_float(Value value, long l, double d) throws Fail.Exception {
        if (l < 0L || l >= value.sizeDoubles()) {
            Fail.arrayBoundError();
        }
        value.setDouble(l, d);
        return Value.UNIT;
    }

    public static Value caml_array_set_int(Value value, long l, long l2) throws Fail.Exception {
        if (l < 0L || l >= value.sizeLongs()) {
            Fail.arrayBoundError();
        }
        value.setRawLong(l, l2);
        return Value.UNIT;
    }

    public static Value caml_array_set(Value value, long l, Value value2) throws Fail.Exception {
        if (value.isDoubleArray()) {
            return NativeUtils.caml_array_set_float(value, l, value2.asDouble());
        }
        return NativeUtils.caml_array_set_addr(value, l, value2);
    }

    public static Value caml_array_unsafe_get(Value value, long l) {
        if (value.isDoubleArray()) {
            return Value.createDouble(value.getDouble(l));
        }
        return value.get(l);
    }

    public static Value caml_array_unsafe_set(Value value, long l, Value value2) {
        if (value.isDoubleArray()) {
            value.setDouble(l, value2.asDouble());
            return Value.UNIT;
        }
        value.set(l, value2);
        return Value.UNIT;
    }

    public static long caml_string_get(Value value, long l) throws Fail.Exception {
        if (l < 0L || l >= value.sizeBytes()) {
            Fail.arrayBoundError();
        }
        return value.getUnsignedByte(l);
    }

    public static Value caml_string_set(Value value, long l, Value value2) throws Fail.Exception {
        if (l < 0L || l >= value.sizeBytes()) {
            Fail.arrayBoundError();
        }
        value.setUnsignedByte(l, value2.asCastedInt());
        return Value.UNIT;
    }
}

