/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.util.Map;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/envir.c")
public final class Envir {
    private Envir() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="string array")
    public static Value unix_environment(Value unit) {
        try {
            Map<String, String> env = System.getenv();
            int sz = env.size();
            if (sz > 0) {
                Value res = Value.createBlock(0, sz + 1);
                res.set(0, Value.createString("OCAMLJAVA_VERSION=2.0-early-access8"));
                int i = 1;
                for (Map.Entry<String, String> e : env.entrySet()) {
                    res.set(i++, Value.createString(e.getKey() + "=" + e.getValue()));
                }
                return res;
            }
            return CurrentContext.getCodeState().getAtom(0);
        }
        catch (SecurityException se) {
            return Value.createBlock(0, 0L);
        }
    }
}

