/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.ocamljava.runtime.util.IntegerUtils;

public final class IO {
    private static final int BITS_PER_BYTE = 8;
    private static final int BYTE_MASK = 255;

    private IO() {
    }

    public static int read8u(DataInput dataInput) throws IOException {
        assert (dataInput != null) : "null in";
        return dataInput.readUnsignedByte();
    }

    public static int read8s(DataInput dataInput) throws IOException {
        assert (dataInput != null) : "null in";
        return dataInput.readByte();
    }

    public static int read16u(DataInput dataInput) throws IOException {
        assert (dataInput != null) : "null in";
        return dataInput.readUnsignedShort();
    }

    public static int read16s(DataInput dataInput) throws IOException {
        assert (dataInput != null) : "null in";
        return dataInput.readShort();
    }

    public static long read32u(DataInput dataInput) throws IOException {
        assert (dataInput != null) : "null in";
        return IntegerUtils.signedToUnsigned(dataInput.readInt());
    }

    public static int read32s(DataInput dataInput) throws IOException {
        assert (dataInput != null) : "null in";
        return dataInput.readInt();
    }

    public static long read64s(DataInput dataInput) throws IOException {
        assert (dataInput != null) : "null in";
        return dataInput.readLong();
    }

    public static void write8u(DataOutput dataOutput, int n) throws IOException {
        assert (dataOutput != null) : "null out";
        assert (n >= 0 && n <= 255) : "val should be in 0..255";
        dataOutput.write(n);
    }

    public static void write8s(DataOutput dataOutput, int n) throws IOException {
        assert (dataOutput != null) : "null out";
        assert (n >= -128 && n <= 127) : "val should be in -128..127";
        dataOutput.writeByte(n);
    }

    public static void write16u(DataOutput dataOutput, int n) throws IOException {
        assert (dataOutput != null) : "null out";
        assert (n >= 0 && n <= 65535) : "val should be in 0..65535";
        dataOutput.write(0xFF & n >> 8);
        dataOutput.write(0xFF & n);
    }

    public static void write16s(DataOutput dataOutput, int n) throws IOException {
        assert (dataOutput != null) : "null out";
        assert (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) : "val should be in -32768..32767";
        dataOutput.writeShort(n);
    }

    public static void write32u(DataOutput dataOutput, long l) throws IOException {
        assert (dataOutput != null) : "null out";
        assert (l >= 0L && l <= 0xFFFFFFFFL) : "val should be in 0..4294967295";
        dataOutput.writeInt(IntegerUtils.unsignedToSigned(l));
    }

    public static void write32s(DataOutput dataOutput, int n) throws IOException {
        assert (dataOutput != null) : "null out";
        dataOutput.writeInt(n);
    }

    public static void write64s(DataOutput dataOutput, long l) throws IOException {
        assert (dataOutput != null) : "null out";
        dataOutput.writeLong(l);
    }
}

