/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.systhreads;

import java.util.concurrent.Semaphore;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.CustomThreadStatus;
import org.ocamljava.runtime.values.Value;

public final class ThreadStatus {
    private Semaphore alive = new Semaphore(1, true);
    private final OCamlJavaThread thread;

    public ThreadStatus(CodeRunner bc, OCamlJavaThread ct) {
        try {
            this.alive.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = ct != null ? ct : new OCamlJavaThread(bc.getContext().getThreadsState().getThreadGroup(), bc);
    }

    public static Value createValue(ThreadStatus ts) {
        return Value.createCustom(CustomThreadStatus.OPS, 1L, ts);
    }

    public OCamlJavaThread getThread() {
        return this.thread;
    }

    public void terminate() {
        this.alive.release();
        this.thread.asksToStop();
    }

    public void suspend() {
        this.thread.pause();
    }

    public void resume() {
        this.thread.wakeUp();
    }

    public boolean isSuspended() {
        return this.thread.isPaused();
    }

    public boolean isAlive() {
        return this.alive.availablePermits() == 0;
    }

    void waitTerm(Context ctxt) throws FalseExit, Fail.Exception {
        assert (ctxt != null) : "null ctxt";
        try {
            this.alive.acquire();
        }
        catch (InterruptedException ie) {
            FalseExit fe = FalseExit.createFromContext(ctxt);
            fe.fillInStackTrace();
            throw fe;
        }
        this.alive.release();
    }
}

