/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.atomic.AtomicIntegerArray;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="AtomicInt32Array", source="")
public final class AtomicInt32Array {
    private AtomicInt32Array() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int32"}, returnType="AtomicInt32Array.t")
    public static Value ocamljava_atomicint32array_make(Value value) throws Fail.Exception {
        try {
            return Value.createInstance(new AtomicIntegerArray(value.asInt32()));
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.AtomicInt32Array.make");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32", "int32"}, returnType="int32")
    public static Value ocamljava_atomicint32array_add_and_get(Value value, Value value2, Value value3) throws Fail.Exception {
        try {
            AtomicIntegerArray atomicIntegerArray = (AtomicIntegerArray)value.asCustom();
            int n = atomicIntegerArray.addAndGet(value2.asInt32(), value3.asInt32());
            return Value.createInt32(n);
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32", "int32", "int32"}, returnType="bool")
    public static Value ocamljava_atomicint32array_compare_and_set(Value value, Value value2, Value value3, Value value4) throws Fail.Exception {
        try {
            Value value5;
            AtomicIntegerArray atomicIntegerArray = (AtomicIntegerArray)value.asCustom();
            boolean bl = atomicIntegerArray.compareAndSet(value2.asInt32(), value3.asInt32(), value4.asInt32());
            if (bl) {
                value5 = Value.TRUE;
                return value5;
            }
            value5 = Value.FALSE;
            return value5;
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32"}, returnType="int32")
    public static Value ocamljava_atomicint32array_decrement_and_get(Value value, Value value2) throws Fail.Exception {
        try {
            AtomicIntegerArray atomicIntegerArray = (AtomicIntegerArray)value.asCustom();
            int n = atomicIntegerArray.decrementAndGet(value2.asInt32());
            return Value.createInt32(n);
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32"}, returnType="int32")
    public static Value ocamljava_atomicint32array_get(Value value, Value value2) throws Fail.Exception {
        try {
            AtomicIntegerArray atomicIntegerArray = (AtomicIntegerArray)value.asCustom();
            int n = atomicIntegerArray.get(value2.asInt32());
            return Value.createInt32(n);
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32", "int32"}, returnType="int32")
    public static Value ocamljava_atomicint32array_get_and_add(Value value, Value value2, Value value3) throws Fail.Exception {
        try {
            AtomicIntegerArray atomicIntegerArray = (AtomicIntegerArray)value.asCustom();
            int n = atomicIntegerArray.getAndAdd(value2.asInt32(), value3.asInt32());
            return Value.createInt32(n);
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32"}, returnType="int32")
    public static Value ocamljava_atomicint32array_get_and_decrement(Value value, Value value2) throws Fail.Exception {
        try {
            AtomicIntegerArray atomicIntegerArray = (AtomicIntegerArray)value.asCustom();
            int n = atomicIntegerArray.getAndDecrement(value2.asInt32());
            return Value.createInt32(n);
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32"}, returnType="int32")
    public static Value ocamljava_atomicint32array_get_and_increment(Value value, Value value2) throws Fail.Exception {
        try {
            AtomicIntegerArray atomicIntegerArray = (AtomicIntegerArray)value.asCustom();
            int n = atomicIntegerArray.getAndIncrement(value2.asInt32());
            return Value.createInt32(n);
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32", "int32"}, returnType="int32")
    public static Value ocamljava_atomicint32array_get_and_set(Value value, Value value2, Value value3) throws Fail.Exception {
        try {
            AtomicIntegerArray atomicIntegerArray = (AtomicIntegerArray)value.asCustom();
            int n = atomicIntegerArray.getAndSet(value2.asInt32(), value3.asInt32());
            return Value.createInt32(n);
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32"}, returnType="int32")
    public static Value ocamljava_atomicint32array_increment_and_get(Value value, Value value2) throws Fail.Exception {
        try {
            AtomicIntegerArray atomicIntegerArray = (AtomicIntegerArray)value.asCustom();
            int n = atomicIntegerArray.incrementAndGet(value2.asInt32());
            return Value.createInt32(n);
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32", "int32"}, returnType="unit")
    public static Value ocamljava_atomicint32array_lazy_set(Value value, Value value2, Value value3) throws Fail.Exception {
        try {
            AtomicIntegerArray atomicIntegerArray = (AtomicIntegerArray)value.asCustom();
            atomicIntegerArray.lazySet(value2.asInt32(), value3.asInt32());
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t"}, returnType="int32")
    public static Value ocamljava_atomicint32array_length(Value value) {
        AtomicIntegerArray atomicIntegerArray = (AtomicIntegerArray)value.asCustom();
        int n = atomicIntegerArray.length();
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32", "int32"}, returnType="unit")
    public static Value ocamljava_atomicint32array_set(Value value, Value value2, Value value3) throws Fail.Exception {
        try {
            AtomicIntegerArray atomicIntegerArray = (AtomicIntegerArray)value.asCustom();
            atomicIntegerArray.set(value2.asInt32(), value3.asInt32());
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32", "int32", "int32"}, returnType="bool")
    public static Value ocamljava_atomicint32array_weak_compare_and_set(Value value, Value value2, Value value3, Value value4) throws Fail.Exception {
        try {
            Value value5;
            AtomicIntegerArray atomicIntegerArray = (AtomicIntegerArray)value.asCustom();
            boolean bl = atomicIntegerArray.weakCompareAndSet(value2.asInt32(), value3.asInt32(), value4.asInt32());
            if (bl) {
                value5 = Value.TRUE;
                return value5;
            }
            value5 = Value.FALSE;
            return value5;
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }
}

