/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.javabase;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.AbstractCodeRunner;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.NativeApply;
import org.ocamljava.runtime.kernel.NativeArithmetic;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.javalibs.javabase.MethodMapping;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="[XXX]", module="[XXX]", source="XXX.c")
public final class Java {
    private Java() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"java'io'InputStream java_instance"}, returnType="in_channel")
    public static Value ocamljava_java_make_in_channel(Value value) {
        Channel channel = new Channel((InputStream)value.asCustom());
        CurrentContext.FILES_STATE.addChannel(channel);
        return Value.createChannel(channel);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"java'io'OutputStream java_instance"}, returnType="out_channel")
    public static Value ocamljava_java_make_out_channel(Value value) {
        Channel channel = new Channel((OutputStream)value.asCustom());
        CurrentContext.FILES_STATE.addChannel(channel);
        return Value.createChannel(channel);
    }

    public static Object ocamljava_java_make_single_proxy(Class<?> clazz, Value value, MethodMapping methodMapping) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Class[] classArray = new Class[]{clazz};
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        SingleInvocationHandler singleInvocationHandler = new SingleInvocationHandler(value, codeRunner, methodMapping);
        Object object = Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)singleInvocationHandler);
        return object;
    }

    private static Value convert(Object object, Class<?> clazz) {
        if (Value.class.equals(clazz)) {
            return (Value)object;
        }
        if (Boolean.class.equals(clazz)) {
            return (Boolean)object != false ? Value.TRUE : Value.FALSE;
        }
        if (Byte.class.equals(clazz)) {
            return Value.createLong(((Byte)object).byteValue());
        }
        if (Character.class.equals(clazz)) {
            return Value.createLong(((Character)object).charValue());
        }
        if (Double.class.equals(clazz)) {
            return Value.createDouble((Double)object);
        }
        if (Float.class.equals(clazz)) {
            return Value.createDouble(((Float)object).floatValue());
        }
        if (Integer.class.equals(clazz)) {
            return Value.createInt32((Integer)object);
        }
        if (Long.class.equals(clazz)) {
            return Value.createInt64((Long)object);
        }
        if (Short.class.equals(clazz)) {
            return Value.createLong(((Short)object).shortValue());
        }
        return Value.createInstance(object);
    }

    private static final long methodTag(String string) {
        long l = 1L;
        long l2 = 447L;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            long l3 = IntegerUtils.signedToUnsignedByte(EncodingUtils.convertCharToByte(string.charAt(i)));
            l = NativeArithmetic.mulint(447L, l);
            l = NativeArithmetic.addint(l, l3 << 1 | 1L);
        }
        long l4 = l >> 1;
        l4 = (l4 &= Integer.MAX_VALUE) > 0x3FFFFFFFL ? l4 - 0x80000000L : l4;
        return l4 << 1 | 1L;
    }

    static class SingleInvocationHandler
    implements InvocationHandler {
        private final Value instance;
        private final CodeRunner runner;
        private final MethodMapping mapping;
        private final Map<Method, Value> cache;

        SingleInvocationHandler(Value value, CodeRunner codeRunner, MethodMapping methodMapping) {
            assert (value != null) : "null i";
            assert (codeRunner != null) : "null cr";
            assert (methodMapping != null) : "null mm";
            this.instance = value;
            this.runner = codeRunner;
            this.mapping = methodMapping;
            this.cache = new HashMap<Method, Value>();
        }

        private Value getClosure(Method method) {
            Value value = this.cache.get(method);
            if (value == null) {
                String string = this.mapping == null ? method.getName() : this.mapping.get(method);
                Value value2 = AbstractCodeRunner.getMethod(this.instance, Java.methodTag(string));
                this.cache.put(method, value2);
                return value2;
            }
            return value;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Value value = this.getClosure(method);
            int n = objectArray == null ? 0 : objectArray.length;
            Value[] valueArray = new Value[n + 1];
            Class<?>[] classArray = method.getParameterTypes();
            valueArray[0] = this.instance;
            for (int i = 0; i < n; ++i) {
                Value value2;
                valueArray[i + 1] = value2 = Java.convert(objectArray[i], classArray[i]);
            }
            OCamlJavaThread.registerCodeRunner(Thread.currentThread(), this.runner);
            return NativeApply.apply(value, valueArray);
        }
    }
}

