/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.graph;

import java.awt.Point;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="graph", module="Graphics", source="otherlibs/graph/events.c")
public final class Events {
    static final int EVENT_BUTTON_DOWN = 0;
    static final int EVENT_BUTTON_UP = 1;
    static final int EVENT_KEY_PRESSED = 2;
    static final int EVENT_MOUSE_MOTION = 3;
    static final int EVENT_POLL = 4;

    private Events() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Graphics.event list"}, returnType="Graphics.status")
    public static Value caml_gr_wait_event(Value events) throws Fail.Exception, FalseExit {
        GraphSlot slot = GraphSlot.checkGraph();
        boolean pressed = false;
        boolean released = false;
        boolean keyPressed = false;
        boolean motion = false;
        boolean poll = false;
        block7: for (Value list = events; list != Value.EMPTY_LIST; list = list.get1()) {
            switch (list.get0().asCastedInt()) {
                case 0: {
                    pressed = true;
                    continue block7;
                }
                case 1: {
                    released = true;
                    continue block7;
                }
                case 2: {
                    keyPressed = true;
                    continue block7;
                }
                case 3: {
                    motion = true;
                    continue block7;
                }
                case 4: {
                    poll = true;
                    continue block7;
                }
                default: {
                    assert (false) : "invalid Graphics.event";
                    continue block7;
                }
            }
        }
        if (poll) {
            return Events.waitEventPoll(slot);
        }
        return slot.waitEvent(pressed, released, keyPressed, motion);
    }

    private static Value waitEventPoll(GraphSlot slot) {
        int mouseY;
        int mouseX;
        Point pt = slot.getFrame().getMousePosition();
        if (pt != null) {
            mouseX = pt.x;
            mouseY = pt.y;
        } else {
            mouseX = -1;
            mouseY = -1;
        }
        return Events.allocateResult(slot, mouseX, mouseY, slot.isMouseButton(), slot.getKey());
    }

    static Value allocateResult(GraphSlot slot, int mouseX, int mouseY, boolean button, Integer key) {
        return Value.createBlock(0, Value.createLong(mouseX), Value.createLong(mouseY == -1 ? -1L : (long)slot.convertY(mouseY)), button ? Value.TRUE : Value.FALSE, key != null ? Value.TRUE : Value.FALSE, key != null ? Value.createLong(key.intValue()) : Value.ZERO);
    }
}

