/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

public final class EncodingUtils {
    private EncodingUtils() {
    }

    public static byte convertCharToByte(char ch) {
        return (byte)(ch < '\u0100' ? (int)ch : 63);
    }

    public static char convertByteToChar(byte by) {
        return (char)((short)by & 0xFF);
    }

    public static byte[] convertStringToBytes(String s) {
        assert (s != null) : "null s";
        byte[] res = new byte[s.length()];
        EncodingUtils.convertStringToBytes(s, res, 0);
        return res;
    }

    public static void convertStringToBytes(String s, byte[] dest, int ofs) {
        assert (s != null) : "null s";
        assert (dest != null) : "null dest";
        assert (ofs >= 0) : "ofs should be >= 0";
        assert (dest.length >= ofs + s.length()) : "invalid ofs";
        int len = s.length();
        int o = ofs;
        int i = 0;
        while (i < len) {
            dest[o] = EncodingUtils.convertCharToByte(s.charAt(i));
            ++i;
            ++o;
        }
    }

    public static void convertCharsToBytes(char[] ch, byte[] dest, int ofs, int len) {
        assert (ch != null) : "null ch";
        assert (dest != null) : "null dest";
        assert (ofs >= 0) : "ofs should be >= 0";
        assert (len >= 0) : "len should be >= 0";
        assert (dest.length >= ofs + len) : "invalid ofs";
        assert (len <= ch.length) : "invalid len";
        int o = ofs;
        int i = 0;
        while (i < len) {
            dest[o] = EncodingUtils.convertCharToByte(ch[i]);
            ++i;
            ++o;
        }
    }

    public static String convertBytesToString(byte[] b) {
        assert (b != null) : "null b";
        return EncodingUtils.convertBytesToString(b, 0, b.length);
    }

    public static String convertBytesToString(byte[] b, int ofs, int len) {
        assert (b != null) : "null b";
        assert (ofs >= 0) : "ofs should be >= 0";
        assert (len >= 0) : "len should be >= 0";
        assert (ofs + len <= b.length) : "invalid ofs";
        char[] res = new char[len];
        int o = ofs;
        int i = 0;
        while (i < len) {
            res[i] = EncodingUtils.convertByteToChar(b[o]);
            ++i;
            ++o;
        }
        return new String(res);
    }
}

