/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/chown.c")
public final class Chown {
    private Chown() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Emulation by unix executable, if enabled and available."}, parameterTypes={"string", "int", "int"}, returnType="unit")
    public static Value unix_chown(Value path, Value uid, Value gid) throws Fail.Exception, FalseExit {
        String res = Unix.emul("chown", "chown", uid.asLong() + ":" + gid.asLong(), CurrentContext.getFilesState().getRealFile(path).getAbsolutePath());
        if (res == null || res.length() != 0) {
            Unix.fail("chown", "unable to change file owner/group");
        }
        return Value.UNIT;
    }
}

