/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.graph;

import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.util.SignalKind;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="graph", module="Graphics", source="otherlibs/graph/open.c")
public final class Open {
    private static final Value SIGIO_SIGNAL = Value.createLong(SignalKind.ALRM.getNo());
    private static final String MAIN_WINDOW_ID = "0";

    private Open() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="unit")
    public static Value caml_gr_open_graph(Value arg) throws Fail.Exception {
        Context ctxt = CurrentContext.get();
        CodeState codeState = ctxt.getCodeState();
        GraphSlot slot = (GraphSlot)codeState.getSlot(GraphSlot.SLOT);
        if (slot != null) {
            Open.caml_gr_clear_graph(Value.UNIT);
        } else {
            String[] parts = arg.asString().split(" ");
            String geometry = parts[parts.length - 1];
            String prevTitle = (String)codeState.getSlot(GraphSlot.SLOT_TITLE);
            if (prevTitle == null) {
                codeState.registerSlot(GraphSlot.SLOT_TITLE, "OCaml graphics");
                prevTitle = "OCaml graphics";
            }
            try {
                slot = new GraphSlot(ctxt.getParameters(), prevTitle, geometry);
            }
            catch (HeadlessException he) {
                GraphSlot.fail("Cannot open display", "");
            }
            codeState.registerSlot(GraphSlot.SLOT, slot);
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="GraphicsX11.window_id")
    public static Value caml_gr_window_id(Value unit) throws Fail.Exception {
        GraphSlot.checkGraph();
        return Value.createString(MAIN_WINDOW_ID);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_gr_close_graph(Value unit) {
        CodeState codeState = CurrentContext.getCodeState();
        GraphSlot slot = (GraphSlot)codeState.getSlot(GraphSlot.SLOT);
        if (slot != null) {
            Frame f = slot.getFrame();
            if (f != null) {
                f.setVisible(false);
                f.dispose();
            }
            codeState.removeSlot(GraphSlot.SLOT);
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="unit")
    public static Value caml_gr_set_window_title(Value t) {
        CodeState codeState = CurrentContext.getCodeState();
        String s = t.asString();
        codeState.registerSlot(GraphSlot.SLOT_TITLE, s);
        GraphSlot slot = (GraphSlot)codeState.getSlot(GraphSlot.SLOT);
        if (slot != null) {
            slot.getFrame().setTitle(s);
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int"}, returnType="unit")
    public static Value caml_gr_resize_window(Value x, Value y) throws Fail.Exception {
        if (!CurrentContext.getParameters().isBareCanvas()) {
            GraphSlot.checkGraph().changeSize(x.asCastedInt(), y.asCastedInt());
            Open.caml_gr_clear_graph(Value.UNIT);
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_gr_clear_graph(Value unit) throws Fail.Exception {
        Graphics2D store;
        GraphSlot slot = GraphSlot.checkGraph();
        BufferedImage buffer = slot.getBuffer();
        int w = buffer.getWidth();
        int h = buffer.getHeight();
        Graphics2D win = slot.createWindowGraphics();
        if (win != null) {
            win.setColor(slot.getBackground());
            win.fillRect(0, 0, w, h);
            win.dispose();
            slot.repaint();
        }
        if ((store = slot.createBackingStoreGraphics()) != null) {
            store.setColor(slot.getBackground());
            store.fillRect(0, 0, w, h);
            store.dispose();
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="int")
    public static Value caml_gr_size_x(Value unit) throws Fail.Exception {
        return Value.createLong(GraphSlot.checkGraph().getWidth());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="int")
    public static Value caml_gr_size_y(Value unit) throws Fail.Exception {
        return Value.createLong(GraphSlot.checkGraph().getHeight());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"bool"}, returnType="unit")
    public static Value caml_gr_display_mode(Value b) throws Fail.Exception {
        GraphSlot.checkGraph().setDisplayMode(b != Value.FALSE);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"bool"}, returnType="unit")
    public static Value caml_gr_remember_mode(Value b) throws Fail.Exception {
        GraphSlot.checkGraph().setRememberMode(b != Value.FALSE);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_gr_synchronize(Value unit) throws Fail.Exception {
        GraphSlot slot = GraphSlot.checkGraph();
        Graphics2D g = slot.getBuffer().createGraphics();
        g.drawImage((Image)slot.getBackingStore(), 0, 0, null);
        g.dispose();
        slot.repaint();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="int")
    public static Value caml_gr_sigio_signal(Value unit) {
        return SIGIO_SIGNAL;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="unit")
    public static Value caml_gr_sigio_handler(Value unit) {
        return Value.UNIT;
    }
}

