/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.ocamljava.runtime.kernel.Dispatcher;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.values.Value;

final class ReflectionDispatcher
implements Dispatcher {
    private int size;
    private String[] names;
    private Method[] implementations;

    ReflectionDispatcher(String[] stringArray, Method[] methodArray) {
        assert (stringArray != null) : "null nams";
        assert (methodArray != null) : "null impls";
        assert (stringArray.length == methodArray.length) : "nams and impls should have the same length";
        this.size = stringArray.length;
        this.names = Arrays.copyOf(stringArray, stringArray.length);
        this.implementations = Arrays.copyOf(methodArray, methodArray.length);
    }

    @Override
    public String[] getNames() {
        return this.names;
    }

    @Override
    public Method[] getMethods() {
        return this.implementations;
    }

    @Override
    public String getName(int n) {
        if (n >= 0 && n < this.size) {
            return this.names[n];
        }
        return null;
    }

    @Override
    public Method getMethod(int n) {
        if (n >= 0 && n < this.size) {
            return this.implementations[n];
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Value invoke(int n, Value[] valueArray) throws Fatal.Exception, Fail.Exception, FalseExit {
        assert (valueArray != null) : "null params";
        if (n >= 0 && n < this.size) {
            try {
                return (Value)this.implementations[n].invoke(null, (Object[])valueArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                Fatal.raise("illegal access to primitive: " + this.getName(n));
                return null;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable.getCause();
                if (throwable2 instanceof Fail.Exception) {
                    throw (Fail.Exception)throwable2;
                }
                if (throwable2 instanceof Fatal.Exception) {
                    throw (Fatal.Exception)throwable2;
                }
                if (throwable2 instanceof FalseExit) {
                    throw (FalseExit)throwable2;
                }
                throwable.printStackTrace();
                StringWriter stringWriter = new StringWriter();
                stringWriter.append("primitive error: ");
                stringWriter.append(this.getName(n));
                stringWriter.append('\n');
                if (throwable2 != null) {
                    throwable2.printStackTrace(new PrintWriter(stringWriter));
                }
                Fatal.raise(stringWriter.toString());
                return null;
            }
        }
        Fatal.raise("undefined primitive: " + n);
        return null;
    }

    @Override
    public Value invoke(int n, Value value) throws Fatal.Exception, Fail.Exception, FalseExit {
        assert (value != null) : "null p0";
        return this.invoke(n, new Value[]{value});
    }

    @Override
    public Value invoke(int n, Value value, Value value2) throws Fatal.Exception, Fail.Exception, FalseExit {
        assert (value != null) : "null p0";
        assert (value2 != null) : "null p1";
        return this.invoke(n, new Value[]{value, value2});
    }

    @Override
    public Value invoke(int n, Value value, Value value2, Value value3) throws Fatal.Exception, Fail.Exception, FalseExit {
        assert (value != null) : "null p0";
        assert (value2 != null) : "null p1";
        assert (value3 != null) : "null p2";
        return this.invoke(n, new Value[]{value, value2, value3});
    }

    @Override
    public Value invoke(int n, Value value, Value value2, Value value3, Value value4) throws Fatal.Exception, Fail.Exception, FalseExit {
        assert (value != null) : "null p0";
        assert (value2 != null) : "null p1";
        assert (value3 != null) : "null p2";
        assert (value4 != null) : "null p3";
        return this.invoke(n, new Value[]{value, value2, value3, value4});
    }

    @Override
    public Value invoke(int n, Value value, Value value2, Value value3, Value value4, Value value5) throws Fatal.Exception, Fail.Exception, FalseExit {
        assert (value != null) : "null p0";
        assert (value2 != null) : "null p1";
        assert (value3 != null) : "null p2";
        assert (value4 != null) : "null p3";
        assert (value5 != null) : "null p4";
        return this.invoke(n, new Value[]{value, value2, value3, value4, value5});
    }

    @Override
    public int addPrimitive(String string, Method method) {
        assert (string != null) : "null name";
        assert (method != null) : "null impl";
        int n = this.size++;
        Method[] methodArray = new Method[this.size];
        System.arraycopy(this.implementations, 0, methodArray, 0, n);
        methodArray[n] = method;
        this.implementations = methodArray;
        String[] stringArray = new String[this.size];
        System.arraycopy(this.names, 0, stringArray, 0, n);
        stringArray[n] = string;
        this.names = stringArray;
        return n;
    }
}

