/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class LargeWeakBlockValue
extends BlockValue {
    private static final int BITS = 31;
    private static final int MASK = Integer.MAX_VALUE;
    private long length;
    private WeakReference<Value>[][] values;

    LargeWeakBlockValue(long sz) {
        super(251, sz);
        assert (sz >= 0L) : "sz should be >= 0";
        int len = (int)(sz >> 31) + 1;
        int lenLast = (int)sz & Integer.MAX_VALUE;
        this.length = sz;
        this.values = new WeakReference[len][];
        for (int i = 0; i < len - 1; ++i) {
            this.values[i] = new WeakReference[Integer.MIN_VALUE];
            for (int j = 0; j < Integer.MIN_VALUE; ++j) {
                this.values[i][j] = new WeakReference<Object>(null);
            }
        }
        this.values[len - 1] = new WeakReference[lenLast];
        for (int j = 0; j < lenLast; ++j) {
            this.values[len - 1][j] = new WeakReference<Object>(null);
        }
    }

    @Override
    public Value getWeak(long idx) throws ArrayIndexOutOfBoundsException {
        int idx1 = (int)(idx >> 31);
        int idx2 = (int)idx & Integer.MAX_VALUE;
        return (Value)this.values[idx1][idx2].get();
    }

    @Override
    public void setWeak(long idx, Value x) throws ArrayIndexOutOfBoundsException {
        int idx1 = (int)(idx >> 31);
        int idx2 = (int)idx & Integer.MAX_VALUE;
        this.values[idx1][idx2] = new WeakReference<Value>(x);
    }

    @Override
    public long sizeWeakValues() {
        return this.length;
    }

    @Override
    protected void truncateInstance(long sz) {
        WeakReference<Value>[][] oldValues = this.values;
        int len = (int)(sz >> 31) + 1;
        int lenLast = (int)sz & Integer.MAX_VALUE;
        this.length = sz;
        this.values = new WeakReference[len][];
        for (int i = 0; i < len - 1; ++i) {
            this.values[i] = new WeakReference[Integer.MIN_VALUE];
            for (int j = 0; j < Integer.MIN_VALUE; ++j) {
                this.values[i][j] = oldValues[i][j];
            }
        }
        this.values[len - 1] = new WeakReference[lenLast];
        for (int j = 0; j < lenLast; ++j) {
            this.values[len - 1][j] = oldValues[len - 1][j];
        }
    }

    @Override
    public void copy(BlockValue src) {
        long len = Math.min(this.length, src.sizeWeakValues());
        for (long i = 0L; i < len; ++i) {
            this.setWeak(i, src.getWeak(i));
        }
    }

    @Override
    public LargeWeakBlockValue duplicate() {
        long len = this.length;
        LargeWeakBlockValue res = new LargeWeakBlockValue(len);
        for (long i = 0L; i < len; ++i) {
            res.setWeak(i, this.getWeak(i));
        }
        return res;
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeWeakValues());
        for (int i = 0; i < len; ++i) {
            dest[i] = this.getWeak(i);
        }
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeWeakValues());
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.getWeak(i);
        }
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeWeakValues());
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.getWeak(i).asDouble();
        }
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeWeakValues());
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.getWeak(i).getRawValue();
        }
    }

    @Override
    public Value subArray(long ofs, long len) {
        LargeWeakBlockValue res = new LargeWeakBlockValue(len);
        for (long i = 0L; i < len; ++i) {
            res.setWeak(i, this.getWeak(i + ofs));
        }
        return res;
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
        if (destOfs < srcOfs) {
            for (long i = 0L; i < len; ++i) {
                dest.setWeak(destOfs + i, this.getWeak(srcOfs + i));
            }
        } else {
            for (long i = len - 1L; i >= 0L; --i) {
                dest.setWeak(destOfs + i, this.getWeak(srcOfs + i));
            }
        }
    }

    public int hashCode() {
        int res = 0;
        WeakReference<Value>[] v = this.values[0];
        int len = Math.min(32, v.length);
        for (int i = 0; i < len; ++i) {
            res += v[i].hashCode();
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LargeWeakBlockValue) {
            LargeWeakBlockValue that = (LargeWeakBlockValue)obj;
            int lenThis = this.values.length;
            int lenThat = that.values.length;
            if (lenThis == lenThis) {
                int i;
                for (i = 0; i < lenThis && Arrays.equals(this.values[i], that.values[i]); ++i) {
                }
                return i == lenThis;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LargeWeakBlockValue(");
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            int l = this.values[i].length;
            for (int j = 0; j < l; ++j) {
                Value v;
                if (i + j != 0) {
                    sb.append(", ");
                }
                sb.append((v = (Value)this.values[i][j].get()) == null ? "null" : v.toString());
            }
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void set(Value x, long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "set(Value, long) called on an instance of " + this.getClass();
    }

    @Override
    public void setParent(BlockValue b) {
        assert (false) : "setParent(BlockValue) called on an instance of " + this.getClass();
    }

    @Override
    public BlockValue getParent() {
        assert (false) : "getParent() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public CustomOperations getCustomOperations() {
        assert (false) : "getCustomOperations() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Object asCustom() {
        assert (false) : "asCustom() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setCustom(Object o) {
        assert (false) : "setCustom(Object) called on an instance of " + this.getClass();
    }

    @Override
    public int asInt32() {
        assert (false) : "asInt32() called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setInt32(int v) {
        assert (false) : "setInt32(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asInt64() {
        assert (false) : "asInt64() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setInt64(long v) {
        assert (false) : "setInt64(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asNativeInt() {
        assert (false) : "asNativeInt() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setNativeInt(long v) {
        assert (false) : "setNativeInt(long) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeBytes() {
        assert (false) : "sizeBytes() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytesTagged() {
        assert (false) : "sizeBytesTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytesMinusOneTagged() {
        assert (false) : "sizeBytesMinusOneTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public Value sizeBytesWrapped() {
        assert (false) : "sizeBytesWrapped() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public String asString() {
        assert (false) : "asString() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public byte[] getBytes() {
        assert (false) : "getBytes() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public byte[] getBytesForModification() {
        assert (false) : "getBytesForModification() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public int[] getUnsignedBytes() {
        assert (false) : "getUnsignedBytes() called on an instance of " + this.getClass();
        return new int[0];
    }

    @Override
    public byte getByte(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setByte(long idx, byte x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setByte(long, byte) called on an instance of " + this.getClass();
    }

    @Override
    public int getUnsignedByte(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getUnsignedByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setUnsignedByte(long idx, int x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setUnsignedByte(long, int) called on an instance of " + this.getClass();
    }

    @Override
    public int asCastedInt() {
        return -1;
    }

    @Override
    public int asBoundedInt() throws Fatal.Exception {
        return -1;
    }

    @Override
    public long getCode() {
        assert (this.getTag() == 247 || this.getTag() == 249) : "getCode() called on an instance of " + this.getClass();
        return this.get0().asCodeOffset();
    }

    @Override
    public void setCode(long code) {
        assert (this.getTag() == 247 || this.getTag() == 249) : "setCode(long) called on an instance of " + this.getClass();
        this.set0(Value.createCodeOffset(code));
    }

    @Override
    public double asDouble() {
        assert (false) : "asDouble() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setDouble(double d) {
        assert (false) : "setDouble(double) called on an instance of " + this.getClass();
    }

    @Override
    public long getRawLong(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getRawLong(long) called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong(int idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getRawLong(int) called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong0() {
        assert (false) : "getRawLong0() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong1() {
        assert (false) : "getRawLong1() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong2() {
        assert (false) : "getRawLong2() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong3() {
        assert (false) : "getRawLong3() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong4() {
        assert (false) : "getRawLong4() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong5() {
        assert (false) : "getRawLong5() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong6() {
        assert (false) : "getRawLong6() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong7() {
        assert (false) : "getRawLong7() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setRawLong(long idx, long x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setRawLong(long, long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong(int idx, long x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setRawLong(int, long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong0(long x) {
        assert (false) : "setRawLong0(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong1(long x) {
        assert (false) : "setRawLong1(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong2(long x) {
        assert (false) : "setRawLong2(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong3(long x) {
        assert (false) : "setRawLong3(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong4(long x) {
        assert (false) : "setRawLong4(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong5(long x) {
        assert (false) : "setRawLong5(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong6(long x) {
        assert (false) : "setRawLong6(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong7(long x) {
        assert (false) : "setRawLong7(long) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeLongs() {
        assert (false) : "sizeLongs() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public double getDouble(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getDouble(long) called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble(int idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getDouble(int) called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble0() {
        assert (false) : "getDouble0() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble1() {
        assert (false) : "getDouble1() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble2() {
        assert (false) : "getDouble2() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble3() {
        assert (false) : "getDouble3() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble4() {
        assert (false) : "getDouble4() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble5() {
        assert (false) : "getDouble5() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble6() {
        assert (false) : "getDouble6() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble7() {
        assert (false) : "getDouble7() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setDouble(long idx, double x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setDouble(long, double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble(int idx, double x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setDouble(int, double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble0(double x) {
        assert (false) : "setDouble0(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble1(double x) {
        assert (false) : "setDouble1(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble2(double x) {
        assert (false) : "setDouble2(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble3(double x) {
        assert (false) : "setDouble3(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble4(double x) {
        assert (false) : "setDouble4(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble5(double x) {
        assert (false) : "setDouble5(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble6(double x) {
        assert (false) : "setDouble6(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble7(double x) {
        assert (false) : "setDouble7(double) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeDoubles() {
        assert (false) : "sizeDoubles() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public double getGenericDouble(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getGenericDouble(long) called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble(int idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getGenericDouble(int) called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble0() {
        assert (false) : "getGenericDouble0() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble1() {
        assert (false) : "getGenericDouble1() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble2() {
        assert (false) : "getGenericDouble2() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble3() {
        assert (false) : "getGenericDouble3() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble4() {
        assert (false) : "getGenericDouble4() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble5() {
        assert (false) : "getGenericDouble5() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble6() {
        assert (false) : "getGenericDouble6() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble7() {
        assert (false) : "getGenericDouble7() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setGenericDouble(long idx, double x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setGenericDouble(long, double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble(int idx, double x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setGenericDouble(int, double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble0(double x) {
        assert (false) : "setGenericDouble0(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble1(double x) {
        assert (false) : "setGenericDouble1(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble2(double x) {
        assert (false) : "setGenericDouble2(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble3(double x) {
        assert (false) : "setGenericDouble3(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble4(double x) {
        assert (false) : "setGenericDouble4(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble5(double x) {
        assert (false) : "setGenericDouble5(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble6(double x) {
        assert (false) : "setGenericDouble6(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble7(double x) {
        assert (false) : "setGenericDouble7(double) called on an instance of " + this.getClass();
    }

    @Override
    public Value get(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "get(long) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get(int idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "get(int) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get0() {
        assert (false) : "get0() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get1() {
        assert (false) : "get1() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get2() {
        assert (false) : "get2() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get3() {
        assert (false) : "get3() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get4() {
        assert (false) : "get4() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get5() {
        assert (false) : "get5() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get6() {
        assert (false) : "get6() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get7() {
        assert (false) : "get7() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void set(long idx, Value x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "set(long, Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set(int idx, Value x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "set(int, Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set0(Value x) {
        assert (false) : "set0(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set1(Value x) {
        assert (false) : "set1(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set2(Value x) {
        assert (false) : "set2(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set3(Value x) {
        assert (false) : "set3(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set4(Value x) {
        assert (false) : "set4(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set5(Value x) {
        assert (false) : "set5(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set6(Value x) {
        assert (false) : "set6(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set7(Value x) {
        assert (false) : "set7(Value) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeValues() {
        assert (false) : "sizeValues() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long arrayLength() {
        assert (false) : "arrayLength() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long arrayLengthTagged() {
        assert (false) : "arrayLengthTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long arrayLengthMinusOneTagged() {
        assert (false) : "arrayLengthMinusOneTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public Value arrayLengthWrapped() {
        assert (false) : "arrayLengthWrapped() called on an instance of " + this.getClass();
        return null;
    }
}

