/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Array", source="byterun/array.c")
public final class Array {
    private Array() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int"}, returnType="'a")
    public static Value caml_array_get_addr(Value value, Value value2) throws Fail.Exception {
        long l = value2.asLong();
        if (l < 0L || l >= value.sizeValues()) {
            Fail.arrayBoundError();
        }
        return value.get(l);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float array", "int"}, returnType="float")
    public static Value caml_array_get_float(Value value, Value value2) throws Fail.Exception {
        long l = value2.asLong();
        if (l < 0L || l >= value.sizeDoubles()) {
            Fail.arrayBoundError();
        }
        return Value.createDouble(value.getDouble(l));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int"}, returnType="'a")
    public static Value caml_array_get(Value value, Value value2) throws Fail.Exception {
        if (value.isDoubleArray()) {
            return Array.caml_array_get_float(value, value2);
        }
        return Array.caml_array_get_addr(value, value2);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a"}, returnType="unit")
    public static Value caml_array_set_addr(Value value, Value value2, Value value3) throws Fail.Exception {
        long l = value2.asLong();
        if (l < 0L || l >= value.sizeValues()) {
            Fail.arrayBoundError();
        }
        value.set(l, value3);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float array", "int", "float"}, returnType="unit")
    public static Value caml_array_set_float(Value value, Value value2, Value value3) throws Fail.Exception {
        long l = value2.asLong();
        if (l < 0L || l >= value.sizeDoubles()) {
            Fail.arrayBoundError();
        }
        value.setDouble(l, value3.asDouble());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a"}, returnType="unit")
    public static Value caml_array_set(Value value, Value value2, Value value3) throws Fail.Exception {
        if (value.isDoubleArray()) {
            return Array.caml_array_set_float(value, value2, value3);
        }
        return Array.caml_array_set_addr(value, value2, value3);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float array", "int"}, returnType="float")
    public static Value caml_array_unsafe_get_float(Value value, Value value2) {
        return Value.createDouble(value.getDouble(value2.asLong()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int"}, returnType="'a")
    public static Value caml_array_unsafe_get(Value value, Value value2) {
        if (value.isDoubleArray()) {
            return Array.caml_array_unsafe_get_float(value, value2);
        }
        return value.get(value2.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a"}, returnType="unit")
    public static Value caml_array_unsafe_set_addr(Value value, Value value2, Value value3) {
        value.set(value2.asLong(), value3);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a"}, returnType="unit")
    public static Value caml_array_unsafe_set_float(Value value, Value value2, Value value3) {
        value.setDouble(value2.asLong(), value3.asDouble());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a"}, returnType="unit")
    public static Value caml_array_unsafe_set(Value value, Value value2, Value value3) {
        if (value.isDoubleArray()) {
            return Array.caml_array_unsafe_set_float(value, value2, value3);
        }
        return Array.caml_array_unsafe_set_addr(value, value2, value3);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "'a"}, returnType="'a array")
    public static Value caml_make_vect(Value value, Value value2) throws Fail.Exception {
        long l = value.asLong();
        if (l == 0L) {
            return CurrentContext.CODE_STATE.getAtom(0);
        }
        if (value2.isDouble()) {
            double d = value2.asDouble();
            if (l * 1L > 0x3FFFFFFFFFFFFFL) {
                Fail.invalidArgument("Array.make");
            }
            Value value3 = Value.createDoubleArray(l);
            int n = 0;
            while ((long)n < l) {
                value3.setDouble(n, d);
                ++n;
            }
            return value3;
        }
        if (l > 0x3FFFFFFFFFFFFFL) {
            Fail.invalidArgument("Array.make");
        }
        Value value4 = Value.createBlock(0, l);
        int n = 0;
        while ((long)n < l) {
            value4.set(n, value2);
            ++n;
        }
        return value4;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int"}, returnType="int array")
    public static Value caml_make_vect_int(Value value, Value value2) throws Fail.Exception {
        long l = value.asLong();
        long l2 = value2.getRawValue();
        if (l == 0L) {
            return CurrentContext.CODE_STATE.getAtom(0);
        }
        if (l > 0x3FFFFFFFFFFFFFL) {
            Fail.invalidArgument("Array.make");
        }
        Value value3 = Value.createLongBlockFromSize(0, l);
        int n = 0;
        while ((long)n < l) {
            value3.setRawLong(n, l2);
            ++n;
        }
        return value3;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int"}, returnType="int array")
    public static Value caml_make_vect_int$(long l, long l2) throws Fail.Exception {
        long l3 = l >> 1;
        if (l3 == 0L) {
            return CurrentContext.CODE_STATE.getAtom(0);
        }
        if (l3 > 0x3FFFFFFFFFFFFFL) {
            Fail.invalidArgument("Array.make");
        }
        Value value = Value.createLongBlockFromSize(0, l3);
        int n = 0;
        while ((long)n < l3) {
            value.setRawLong(n, l2);
            ++n;
        }
        return value;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array"}, returnType="'a array")
    public static Value caml_make_array(Value value) {
        long l = value.getWoSize();
        if (l == 0L) {
            return value;
        }
        Value value2 = value.get0();
        if (value2.isLong() || !value2.isDouble()) {
            return value;
        }
        Value value3 = Value.createDoubleArray(l);
        for (long i = 0L; i < l; ++i) {
            value3.setDouble(i, value.get(i).asDouble());
        }
        return value3;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a array", "int", "int"}, returnType="unit")
    public static Value caml_array_blit(Value value, Value value2, Value value3, Value value4, Value value5) {
        value.blitArray(value2.asLong(), value3, value4.asLong(), value5.asLong());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "int"}, returnType="'a array")
    public static Value caml_array_sub(Value value, Value value2, Value value3) {
        return value.subArray(value2.asLong(), value3.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "'a array"}, returnType="'a array")
    public static Value caml_array_append(Value value, Value value2) {
        return Array.concat(new Value[]{value, value2});
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array list"}, returnType="'a array")
    public static Value caml_array_concat(Value value) {
        int n = 0;
        Value value2 = value;
        while (value2.isBlock()) {
            ++n;
            value2 = value2.get1();
        }
        Value[] valueArray = new Value[n];
        int n2 = 0;
        value2 = value;
        while (value2.isBlock()) {
            valueArray[n2++] = value2.get0();
            value2 = value2.get1();
        }
        return Array.concat(valueArray);
    }

    private static Value concat(Value[] valueArray) {
        boolean bl = false;
        boolean bl2 = true;
        long l = 0L;
        int n = valueArray.length;
        for (int i = 0; i < n; ++i) {
            Value value = valueArray[i];
            if (value.isDoubleArray()) {
                bl = true;
                bl2 = false;
                l += value.sizeDoubles();
                continue;
            }
            if (value.isLongBlock()) {
                l += value.sizeLongs();
                continue;
            }
            bl2 = false;
            l += value.sizeValues();
        }
        if (bl) {
            if (l < Value.MAX_INTEGER) {
                double[] dArray = new double[(int)l];
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    Value value = valueArray[i];
                    value.copyDoublesIntoArray(dArray, n2);
                    n2 = (int)((long)n2 + (value.isDoubleArray() ? value.sizeDoubles() : value.sizeValues()));
                }
                return Value.createDoubleArray(dArray);
            }
            Value value = Value.createDoubleArray(l);
            long l2 = 0L;
            for (int i = 0; i < n; ++i) {
                Value value2 = valueArray[i];
                long l3 = value2.isDoubleArray() ? value2.sizeDoubles() : value2.sizeValues();
                for (long j = 0L; j < l3; ++j) {
                    value.setDouble(l2 + j, value2.getDouble(j));
                }
                l2 += l3;
            }
            return value;
        }
        if (bl2) {
            if (l < Value.MAX_INTEGER) {
                long[] lArray = new long[(int)l];
                int n3 = 0;
                for (int i = 0; i < n; ++i) {
                    Value value = valueArray[i];
                    value.copyRawLongsIntoArray(lArray, n3);
                    n3 = (int)((long)n3 + (value.isLongBlock() ? value.sizeLongs() : value.sizeValues()));
                }
                return Value.createLongBlock(0, lArray);
            }
            Value value = Value.createLongBlock(0, l);
            long l4 = 0L;
            for (int i = 0; i < n; ++i) {
                Value value3 = valueArray[i];
                long l5 = value3.isLongBlock() ? value3.sizeLongs() : value3.sizeValues();
                for (long j = 0L; j < l5; ++j) {
                    value.setRawLong(l4 + j, value3.getRawLong(j));
                }
                l4 += l5;
            }
            return value;
        }
        if (l < Value.MAX_INTEGER) {
            Value[] valueArray2 = new Value[(int)l];
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                Value value = valueArray[i];
                value.copyValuesIntoArray(valueArray2, n4);
                n4 = (int)((long)n4 + (value.isDoubleArray() ? value.sizeDoubles() : value.sizeValues()));
            }
            return Value.createBlock(0, valueArray2);
        }
        Value value = Value.createBlock(0, l);
        long l6 = 0L;
        for (int i = 0; i < n; ++i) {
            Value value4 = valueArray[i];
            long l7 = value4.isDoubleArray() ? value4.sizeDoubles() : value4.sizeValues();
            for (long j = 0L; j < l7; ++j) {
                value.set(l6 + j, value4.get(j));
            }
            l6 += l7;
        }
        return value;
    }
}

