/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="[runtime]", module="[runtime]", source="byterun/alloc.c")
public final class Alloc {
    private Alloc() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="'a")
    public static Value caml_alloc_dummy(Value value) {
        long l = value.asLong();
        if (l == 0L) {
            return CurrentContext.CODE_STATE.getAtom(0);
        }
        return Value.createBlock(0, l);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="'a")
    public static Value caml_alloc_dummy_float(Value value) {
        long l = value.asLong();
        if (l == 0L) {
            return CurrentContext.CODE_STATE.getAtom(0);
        }
        Value value2 = Value.createDoubleArray(l);
        value2.setTag(0);
        return value2;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a", "'a"}, returnType="unit")
    public static Value caml_update_dummy(Value value, Value value2) {
        BlockValue blockValue = value.asBlock();
        BlockValue blockValue2 = value2.asBlock();
        long l = ((Value)blockValue2).getWoSize();
        int n = ((Value)blockValue2).getTag();
        assert (l == ((Value)blockValue).getWoSize()) : "sizes should be equal";
        assert (n < 251 || n == 254) : "invalid tag";
        ((Value)blockValue).setTag(n);
        ((Value)blockValue).asBlock().copy(((Value)blockValue2).asBlock());
        return Value.UNIT;
    }
}

