/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeoutException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.javalibs.concurrent.Runtime;
import org.ocamljava.runtime.primitives.javalibs.concurrent.TimeUnit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="CyclicBarrier", source="")
public final class CyclicBarrier {
    private CyclicBarrier() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int32"}, returnType="CyclicBarrier.t")
    public static Value ocamljava_cyclicbarrier_make(Value value) throws Fail.Exception {
        try {
            return Value.createInstance(new java.util.concurrent.CyclicBarrier(value.asInt32()));
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.CyclicBarrier.make");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"CyclicBarrier.t"}, returnType="unit")
    public static Value ocamljava_cyclicbarrier_await(Value value) throws Fail.Exception {
        java.util.concurrent.CyclicBarrier cyclicBarrier = (java.util.concurrent.CyclicBarrier)value.asCustom();
        try {
            cyclicBarrier.await();
            return Value.UNIT;
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.CyclicBarrier.await");
            return Value.UNIT;
        }
        catch (BrokenBarrierException brokenBarrierException) {
            Fail.invalidArgument("Concurrent.CyclicBarrier.await");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"CyclicBarrier.t", "int64", "TimeUnit.t"}, returnType="unit")
    public static Value ocamljava_cyclicbarrier_await_time(Value value, Value value2, Value value3) throws Fail.Exception {
        java.util.concurrent.CyclicBarrier cyclicBarrier = (java.util.concurrent.CyclicBarrier)value.asCustom();
        try {
            cyclicBarrier.await(value2.asInt64(), TimeUnit.decode(value3));
            return Value.UNIT;
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.CyclicBarrier.await_time");
            return Value.UNIT;
        }
        catch (BrokenBarrierException brokenBarrierException) {
            Fail.invalidArgument("Concurrent.CyclicBarrier.await_time");
            return Value.UNIT;
        }
        catch (TimeoutException timeoutException) {
            Runtime.raiseTimeout("Concurrent.CyclicBarrier.await_time");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"CyclicBarrier.t"}, returnType="int32")
    public static Value ocamljava_cyclicbarrier_get_number_waiting(Value value) {
        java.util.concurrent.CyclicBarrier cyclicBarrier = (java.util.concurrent.CyclicBarrier)value.asCustom();
        int n = cyclicBarrier.getNumberWaiting();
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"CyclicBarrier.t"}, returnType="int32")
    public static Value ocamljava_cyclicbarrier_get_parties(Value value) {
        java.util.concurrent.CyclicBarrier cyclicBarrier = (java.util.concurrent.CyclicBarrier)value.asCustom();
        int n = cyclicBarrier.getParties();
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"CyclicBarrier.t"}, returnType="bool")
    public static Value ocamljava_cyclicbarrier_is_broken(Value value) {
        java.util.concurrent.CyclicBarrier cyclicBarrier = (java.util.concurrent.CyclicBarrier)value.asCustom();
        boolean bl = cyclicBarrier.isBroken();
        return bl ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"CyclicBarrier.t"}, returnType="unit")
    public static Value ocamljava_cyclicbarrier_reset(Value value) {
        java.util.concurrent.CyclicBarrier cyclicBarrier = (java.util.concurrent.CyclicBarrier)value.asCustom();
        cyclicBarrier.reset();
        return Value.UNIT;
    }
}

