/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.values.Value;
import org.ocamljava.runtime.wrappers.OCamlAssertFailureException;
import org.ocamljava.runtime.wrappers.OCamlDivisionByZeroException;
import org.ocamljava.runtime.wrappers.OCamlEndOfFileException;
import org.ocamljava.runtime.wrappers.OCamlFailureException;
import org.ocamljava.runtime.wrappers.OCamlInvalidArgumentException;
import org.ocamljava.runtime.wrappers.OCamlMatchFailureException;
import org.ocamljava.runtime.wrappers.OCamlNotFoundException;
import org.ocamljava.runtime.wrappers.OCamlOutOfMemoryException;
import org.ocamljava.runtime.wrappers.OCamlStackOverflowException;
import org.ocamljava.runtime.wrappers.OCamlSysBlockedIOException;
import org.ocamljava.runtime.wrappers.OCamlSysErrorException;
import org.ocamljava.runtime.wrappers.OCamlUndefinedRecursiveModuleException;

public class OCamlException
extends RuntimeException {
    static final long serialVersionUID = 304215162058080925L;
    public static final Object SLOT = new Object();

    public OCamlException(Fail.Exception exception) {
        super(exception);
        this.setStackTrace(exception.getStackTrace());
    }

    public OCamlException(Value value) {
        super(new Fail.Exception(value));
    }

    public final Fail.Exception getFailException() {
        return (Fail.Exception)this.getCause();
    }

    public final String getOCamlName() {
        Fail.Exception exception = (Fail.Exception)this.getCause();
        Value value = exception.asValue();
        return value.get0().get0().asString();
    }

    public final String getOCamlStringRepresentation() {
        Fail.Exception exception = (Fail.Exception)this.getCause();
        Value value = exception.asValue();
        return Misc.convertException(value, null);
    }

    @Override
    public final String toString() {
        return this.getOCamlStringRepresentation();
    }

    public static OCamlException wrap(Fail.Exception exception) {
        assert (exception != null) : "null fe";
        Value value = exception.asValue();
        String string = value.get0().get0().asString();
        Constructor<?> constructor = OCamlException.getExceptionMap().get(string);
        if (constructor != null) {
            try {
                return (OCamlException)constructor.newInstance(exception);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                return new OCamlException(exception);
            }
        }
        return new OCamlException(exception);
    }

    public static void register(String string, Class<?> clazz) {
        assert (string != null) : "null id";
        assert (clazz != null) : "null cl";
        try {
            Map<String, Constructor<?>> map = OCamlException.getExceptionMap();
            map.put(string, clazz.getConstructor(Fail.Exception.class));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    static Value getTag(String string) {
        assert (string != null) : "null id";
        AbstractNativeRunner abstractNativeRunner = (AbstractNativeRunner)OCamlJavaThread.getCodeRunner();
        switch (string) {
            case "Out_of_memory": {
                return abstractNativeRunner.exnOutOfMemory;
            }
            case "Sys_error": {
                return abstractNativeRunner.exnSysError;
            }
            case "Failure": {
                return abstractNativeRunner.exnFailure;
            }
            case "Invalid_argument": {
                return abstractNativeRunner.exnInvalidArgument;
            }
            case "End_of_file": {
                return abstractNativeRunner.exnEndOfFile;
            }
            case "Division_by_zero": {
                return abstractNativeRunner.exnDivisionByZero;
            }
            case "Not_found": {
                return abstractNativeRunner.exnNotFound;
            }
            case "Match_failure": {
                return abstractNativeRunner.exnMatchFailure;
            }
            case "Stack_overflow": {
                return abstractNativeRunner.exnStackOverflow;
            }
            case "Sys_blocked_io": {
                return abstractNativeRunner.exnSysBlockedIO;
            }
            case "Assert_failure": {
                return abstractNativeRunner.exnAssertFailure;
            }
            case "Undefined_recursive_module": {
                return abstractNativeRunner.exnUndefinedRecursiveModule;
            }
        }
        return null;
    }

    private static synchronized Map<String, Constructor<?>> getExceptionMap() {
        CodeState codeState = CurrentContext.CODE_STATE;
        Map map = (Map)codeState.getSlot(SLOT);
        if (map == null) {
            HashMap hashMap = new HashMap();
            codeState.registerSlot(SLOT, hashMap);
            return hashMap;
        }
        return map;
    }

    static {
        try {
            OCamlException.register("Not_found", OCamlNotFoundException.class);
            OCamlException.register("Out_of_memory", OCamlOutOfMemoryException.class);
            OCamlException.register("Stack_overflow", OCamlStackOverflowException.class);
            OCamlException.register("End_of_file", OCamlEndOfFileException.class);
            OCamlException.register("Division_by_zero", OCamlDivisionByZeroException.class);
            OCamlException.register("Sys_blocked_io", OCamlSysBlockedIOException.class);
            OCamlException.register("Failure", OCamlFailureException.class);
            OCamlException.register("Invalid_argument", OCamlInvalidArgumentException.class);
            OCamlException.register("Sys_error", OCamlSysErrorException.class);
            OCamlException.register("Match_failure", OCamlMatchFailureException.class);
            OCamlException.register("Assert_failure", OCamlAssertFailureException.class);
            OCamlException.register("Undefined_recursive_module", OCamlUndefinedRecursiveModuleException.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

