/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.graph;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="graph", module="Graphics", source="otherlibs/graph/text.c")
public final class Text {
    private Text() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Argument is interpreted as a Java font name."}, parameterTypes={"string"}, returnType="unit")
    public static Value caml_gr_set_font(Value value) throws Fail.Exception {
        GraphSlot graphSlot = GraphSlot.checkGraph();
        Font font = graphSlot.getFont();
        graphSlot.setFont(new Font(value.asString(), 0, font.getSize()));
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="unit")
    public static Value caml_gr_set_text_size(Value value) throws Fail.Exception {
        GraphSlot graphSlot = GraphSlot.checkGraph();
        Font font = graphSlot.getFont();
        graphSlot.setFont(font.deriveFont((float)value.asCastedInt()));
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"char"}, returnType="unit")
    public static Value caml_gr_draw_char(Value value) throws Fail.Exception {
        Value value2 = Value.createString(1L);
        value2.setUnsignedByte(0L, value.asCastedInt());
        return Text.caml_gr_draw_string(value2);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="unit")
    public static Value caml_gr_draw_string(Value value) throws Fail.Exception {
        Graphics2D graphics2D;
        GraphSlot graphSlot = GraphSlot.checkGraph();
        int n = graphSlot.getX();
        int n2 = graphSlot.convertY(graphSlot.getY());
        String string = value.asString();
        Graphics2D graphics2D2 = graphSlot.createWindowGraphics();
        if (graphics2D2 != null) {
            graphics2D2.drawString(string, n, n2);
            graphics2D2.dispose();
            graphSlot.repaint();
        }
        if ((graphics2D = graphSlot.createBackingStoreGraphics()) != null) {
            graphics2D.drawString(string, n, n2);
            graphics2D.dispose();
        }
        Graphics2D graphics2D3 = graphSlot.getBuffer().createGraphics();
        FontMetrics fontMetrics = graphics2D3.getFontMetrics(graphSlot.getFont());
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D3);
        graphics2D3.dispose();
        graphSlot.setX(n + (int)rectangle2D.getWidth());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="int * int")
    public static Value caml_gr_text_size(Value value) throws Fail.Exception {
        GraphSlot graphSlot = GraphSlot.checkGraph();
        Graphics2D graphics2D = graphSlot.getBuffer().createGraphics();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(graphSlot.getFont());
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(value.asString(), graphics2D);
        graphics2D.dispose();
        return Value.createBlock(0, Value.createLong((int)rectangle2D.getWidth()), Value.createLong((int)rectangle2D.getHeight()));
    }
}

