/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.labltk;

import com.onemoonscientific.swank.ImageCmd;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.otherlibs.labltk.TKSlot;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="labltk", module="Tk", source="otherlibs/labltk/support/cltkImg.c")
public final class CltkImg {
    private CltkImg() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="string")
    public static Value camltk_getimgdata(Value imgname) throws Fail.Exception {
        TKSlot slot = TKSlot.checkInit();
        BufferedImage bi = CltkImg.convertToBufferedImage(ImageCmd.getImage((String)imgname.asString()));
        if (bi != null) {
            int w = bi.getWidth();
            int h = bi.getHeight();
            byte[] bytes = new byte[w * h * 3];
            int ofs = 0;
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    int rgb = bi.getRGB(x, y);
                    bytes[ofs++] = (byte)(rgb >> 16 & 0xFF);
                    bytes[ofs++] = (byte)(rgb >> 8 & 0xFF);
                    bytes[ofs++] = (byte)(rgb & 0xFF);
                }
            }
            return Value.createString((byte[])bytes);
        }
        slot.tkError("no such image");
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string", "int", "int", "int", "int"}, returnType="unit")
    public static Value camltk_setimgdata_native(Value imgname, Value pixmap, Value x, Value y, Value w, Value h) throws Fail.Exception {
        TKSlot slot = TKSlot.checkInit();
        Object original = ImageCmd.getImage((String)imgname.asString());
        BufferedImage bi = CltkImg.convertToBufferedImage(original);
        if (bi != null) {
            byte[] bytes = pixmap.getBytes();
            int size = bytes.length / 3;
            int ofs = 0;
            for (int dy = 0; dy < h.asCastedInt(); ++dy) {
                for (int dx = 0; dx < w.asCastedInt(); ++dx) {
                    bi.setRGB(x.asCastedInt() + dx, y.asCastedInt() + dy, bytes[ofs] << 16 | bytes[ofs + 1] << 8 | bytes[ofs + 2]);
                    ofs += 3;
                }
            }
            if (original instanceof ImageIcon) {
                ((ImageIcon)original).setImage(bi);
            } else {
                ImageCmd.images.put(imgname.asString(), new ImageIcon(bi));
            }
            return Value.UNIT;
        }
        slot.tkError("no such image");
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string", "int", "int", "int", "int"}, returnType="unit")
    public static Value camltk_setimgdata_bytecode(Value imgname, Value pixmap, Value x, Value y, Value w, Value h) throws Fail.Exception {
        return CltkImg.camltk_setimgdata_native(imgname, pixmap, x, y, w, h);
    }

    private static BufferedImage convertToBufferedImage(Object obj) {
        Image img;
        if (obj instanceof BufferedImage) {
            img = (BufferedImage)obj;
        } else if (obj instanceof Image) {
            img = (Image)obj;
        } else if (obj instanceof ImageIcon) {
            img = ((ImageIcon)obj).getImage();
        } else {
            return null;
        }
        if (img instanceof BufferedImage) {
            return img;
        }
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        BufferedImage res = new BufferedImage(w, h, 1);
        Graphics g = res.getGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return res;
    }
}

