/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.annotations.parameters;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.ocamljava.runtime.annotations.parameters.BooleanParameter;
import org.ocamljava.runtime.annotations.parameters.IntegerParameter;
import org.ocamljava.runtime.annotations.parameters.StringParameter;
import org.ocamljava.runtime.kernel.ParameterException;
import org.ocamljava.runtime.parameters.ByteCodeParameters;

final class ParameterComponents {
    private ParameterComponents() {
    }

    static JComponent createComponent(Method method, ByteCodeParameters byteCodeParameters) throws ParameterException {
        assert (method != null) : "null m";
        assert (byteCodeParameters != null) : "null bcp";
        Object object = null;
        try {
            object = method.invoke((Object)byteCodeParameters, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        BooleanParameter booleanParameter = method.getAnnotation(BooleanParameter.class);
        if (booleanParameter != null) {
            JComboBox<String> jComboBox = new JComboBox<String>(booleanParameter.guiStrings());
            if (object != null) {
                jComboBox.setSelectedIndex((Boolean)object != false ? 1 : 0);
            } else {
                jComboBox.setSelectedIndex(booleanParameter.defaultValue() ? 1 : 0);
            }
            return jComboBox;
        }
        IntegerParameter integerParameter = method.getAnnotation(IntegerParameter.class);
        if (integerParameter != null) {
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(object != null ? ((Integer)object).intValue() : integerParameter.defaultValue(), integerParameter.minValue(), integerParameter.maxValue(), 1);
            JSpinner jSpinner = new JSpinner(spinnerNumberModel);
            return jSpinner;
        }
        StringParameter stringParameter = method.getAnnotation(StringParameter.class);
        if (stringParameter != null) {
            String[] stringArray = stringParameter.possibleValues();
            if (stringArray.length == 0) {
                return new JTextField(object != null ? (String)object : stringParameter.defaultValue());
            }
            JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
            jComboBox.setSelectedItem(object != null ? (String)object : stringParameter.defaultValue());
            return jComboBox;
        }
        throw new ParameterException("unsuppoted parameter");
    }

    static Object readComponentValue(Method method, JComponent jComponent) throws ParameterException {
        assert (method != null) : "null m";
        assert (jComponent != null) : "null comp";
        BooleanParameter booleanParameter = method.getAnnotation(BooleanParameter.class);
        if (booleanParameter != null) {
            return ((JComboBox)jComponent).getSelectedIndex() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        IntegerParameter integerParameter = method.getAnnotation(IntegerParameter.class);
        if (integerParameter != null) {
            return ((JSpinner)jComponent).getValue();
        }
        StringParameter stringParameter = method.getAnnotation(StringParameter.class);
        if (stringParameter != null) {
            if (stringParameter.possibleValues().length == 0) {
                return ((JTextField)jComponent).getText();
            }
            return ((JComboBox)jComponent).getSelectedItem();
        }
        throw new ParameterException("unsuppoted parameter");
    }
}

