/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Gc", source="byterun/finalise.c")
public final class Finalise {
    private Finalise() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"('a -> unit)", "'a"}, returnType="unit")
    public static Value caml_final_register(Value f, Value v) throws Fail.Exception {
        BlockValue b;
        if (!v.isBlock()) {
            Fail.invalidArgument("Gc.finalise");
        }
        if ((b = v.asBlock()).getTag() == 249) {
            b = b.getParent();
        }
        CurrentContext.getFinalizersState().addFinalizer(b, f, OCamlJavaThread.getCodeRunner());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value caml_final_release(Value unit) {
        return Value.UNIT;
    }
}

