/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.IOException;
import java.util.Map;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.context.FilesState;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.util.StreamCopyThread;

public abstract class ProcessRunner {
    private ProcessRunner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execute(FilesState fs, String[] cmd, String[] env, boolean lock) throws InterruptedException, IOException, FalseExit, Fail.Exception {
        assert (fs != null) : "null fs";
        assert (cmd != null) : "null cmd";
        try {
            Channel in;
            Channel err;
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.directory(fs.getPwd());
            if (env != null) {
                Map<String, String> environment = pb.environment();
                environment.clear();
                for (String s : env) {
                    int idx = s.indexOf(61);
                    if (idx < 0) continue;
                    environment.put(s.substring(0, idx), s.substring(idx + 1));
                }
            }
            if (lock) {
                CurrentContext.enterBlockingSection();
            }
            Process p = pb.start();
            Thread[] threads = new Thread[3];
            boolean[] join = new boolean[3];
            int nextThread = 0;
            Channel out = fs.getChannel(1);
            if (out != null) {
                StreamCopyThread t = new StreamCopyThread(out.newOutputStream(), false, p.getInputStream(), true, false);
                join[nextThread] = true;
                threads[nextThread++] = t;
                t.start();
            }
            if ((err = fs.getChannel(2)) != null) {
                StreamCopyThread t = new StreamCopyThread(err.newOutputStream(), false, p.getErrorStream(), true, false);
                join[nextThread] = true;
                threads[nextThread++] = t;
                t.start();
            }
            if ((in = fs.getChannel(0)) != null) {
                StreamCopyThread t = new StreamCopyThread(p.getOutputStream(), true, in.newInputStream(), false, true);
                join[nextThread] = false;
                threads[nextThread++] = t;
                t.start();
            }
            int res = p.waitFor();
            for (int i = 0; i < nextThread; ++i) {
                if (join[i]) {
                    threads[i].join();
                    continue;
                }
                threads[i].interrupt();
            }
            int n = res;
            return n;
        }
        finally {
            if (lock) {
                CurrentContext.leaveBlockingSection();
            }
        }
    }
}

