/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.ItemImage;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import java.awt.image.BufferedImage;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class ImageParameter
extends CanvasParameter {
    private static String name = "image";
    private static String defValue = "";
    private BufferedImage newImage = null;
    private String newName = null;

    public String getName() {
        return name;
    }

    public String getDefault() {
        return defValue;
    }

    public boolean isParameterLabel(String s) {
        return s.length() > 3 && "-image".startsWith(s);
    }

    public TclObject getValue(Interp interp, SwkShape swkShape) throws TclException {
        if (swkShape == null) {
            throw new TclException(interp, "shape doesn't exist");
        }
        if (swkShape instanceof ItemImage) {
            return TclString.newInstance((String)swkShape.imageName);
        }
        throw new TclException(interp, "shape not image");
    }

    public void setValue(Interp interp, SwkImageCanvas swkCanvas, TclObject arg) throws TclException {
        this.newImage = SwankUtil.getBufferedImage(interp, arg);
        this.newName = arg.toString();
    }

    public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
        if (swkShape != null && swkShape instanceof ItemImage) {
            swkShape.imageName = this.newName;
            ((ItemImage)swkShape).setImage(this.newImage);
        }
    }
}

