/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.BindEvent;
import com.onemoonscientific.swank.SwkJScrollBar;
import com.onemoonscientific.swank.SwkListener;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.EventObject;
import tcl.lang.Interp;
import tcl.lang.TclEvent;
import tcl.lang.TclException;

public class SwkScrollAdjustmentListener
implements AdjustmentListener,
SwkListener {
    Interp interp;
    String command = null;
    Component component;

    SwkScrollAdjustmentListener(Interp interp, Component component) {
        this.interp = interp;
        this.component = component;
    }

    public void setCommand(String name) {
        this.command = name.intern();
    }

    public String getCommand() {
        return this.command;
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        SwkJScrollBar swkjscrollbar = (SwkJScrollBar)this.component;
        if (!swkjscrollbar.lastSetFromSet) {
            int value = e.getValue();
            double fx1 = 1.0 * (double)value / (double)(((SwkJScrollBar)this.component).getMaximum() - ((SwkJScrollBar)this.component).getMinimum());
            Double fxd = new Double(fx1);
            BindEvent bEvent = new BindEvent(this.interp, this, e, fxd, 0);
            this.interp.getNotifier().queueEvent((TclEvent)bEvent, 0);
        } else {
            swkjscrollbar.lastSetFromSet = false;
        }
    }

    public void processEvent(EventObject eventObject, Object obj, int subtype) {
        AdjustmentEvent e = (AdjustmentEvent)eventObject;
        Double fxd = (Double)obj;
        double fx1 = fxd;
        if (this.command != null && this.command.length() != 0) {
            try {
                this.interp.eval(this.command + " moveto " + fx1);
            }
            catch (TclException tclE) {
                System.out.println("error " + tclE.getMessage());
                this.interp.addErrorInfo("\n    (\"binding\" script)");
                this.interp.backgroundError();
            }
        }
    }
}

