/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.Result;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkJList;
import com.onemoonscientific.swank.UpdateOnEventThread;
import com.onemoonscientific.swank.Widgets;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JViewport;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class SwkJListWidgetCmd
implements Command {
    private static final String[] validCmds = new String[]{"cget", "configure", "activate", "bbox", "curselection", "delete", "get", "size", "see", "index", "nearest", "insert", "scan", "selection", "xview", "yview"};
    private static final int OPT_CGET = 0;
    private static final int OPT_CONFIGURE = 1;
    private static final int OPT_ACTIVATE = 2;
    private static final int OPT_BBOX = 3;
    private static final int OPT_CURSELECTION = 4;
    private static final int OPT_DELETE = 5;
    private static final int OPT_GET = 6;
    private static final int OPT_SIZE = 7;
    private static final int OPT_SEE = 8;
    private static final int OPT_INDEX = 9;
    private static final int OPT_NEAREST = 10;
    private static final int OPT_INSERT = 11;
    private static final int OPT_SCAN = 12;
    private static final int OPT_SELECTION = 13;
    private static final int OPT_XVIEW = 14;
    private static final int OPT_YVIEW = 15;
    static boolean gotDefaults = false;
    int index;
    Interp interp = null;

    SwkJListWidgetCmd() {
    }

    public static String[] getValidCmds() {
        return validCmds;
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        this.interp = interp;
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        TclObject tObj = (TclObject)Widgets.getWidget(interp, argv[0].toString());
        if (tObj == null) {
            throw new TclException(interp, "bad window path name \"" + argv[0].toString() + "\"");
        }
        SwkJList swkjlist = (SwkJList)ReflectObject.get((Interp)interp, (TclObject)tObj);
        Result idxResult = new Result();
        switch (opt) {
            case 0: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                interp.setResult(swkjlist.jget(interp, argv[2]));
                break;
            }
            case 1: {
                if (!gotDefaults) {
                    swkjlist.setResourceDefaults();
                    gotDefaults = true;
                }
                if (argv.length == 2) {
                    swkjlist.jgetAll(interp);
                    break;
                }
                if (argv.length == 3) {
                    String result = swkjlist.jget(interp, argv[2]);
                    ResourceObject ro = (ResourceObject)SwkJList.resourceDB.get(argv[2].toString());
                    if (ro == null) {
                        throw new TclException(interp, "unknown option \"" + argv[2].toString() + "\"");
                    }
                    TclObject list = TclList.newInstance();
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)argv[2].toString()));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.resource));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.className));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.defaultVal));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)result));
                    interp.setResult(list);
                    break;
                }
                swkjlist.configure(interp, argv, 2);
                break;
            }
            case 3: {
                this.getBoundingBox(interp, swkjlist, argv);
                break;
            }
            case 4: {
                this.getCurrentSelection(interp, swkjlist, argv);
                break;
            }
            case 5: {
                this.deleteItems(interp, swkjlist, argv);
                break;
            }
            case 6: {
                this.getItems(interp, swkjlist, argv);
                break;
            }
            case 7: {
                this.getSize(interp, swkjlist, argv);
                break;
            }
            case 8: {
                this.seeItem(interp, swkjlist, argv);
                break;
            }
            case 9: {
                this.getIndex(interp, swkjlist, argv);
                break;
            }
            case 2: {
                this.activate(interp, swkjlist, argv);
                break;
            }
            case 10: {
                this.nearest(interp, swkjlist, argv);
                break;
            }
            case 11: {
                this.insert(interp, swkjlist, argv);
                break;
            }
            case 13: {
                this.doSelection(interp, swkjlist, argv);
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                this.viewStuff(interp, swkjlist, argv, opt);
                break;
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    void getBoundingBox(Interp interp, SwkJList swkjlist, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "index");
        }
        Rectangle rect = new BoundingBox().exec(swkjlist, argv[2].toString());
        if (rect != null) {
            interp.setResult(SwankUtil.parseRectangle(rect));
        }
    }

    void getCurrentSelection(Interp interp, SwkJList swkjlist, TclObject[] argv) throws TclException {
        if (argv.length != 2) {
            throw new TclNumArgsException(interp, 2, argv, "");
        }
        int[] selected = new CurrentSelection().exec(swkjlist);
        TclObject list = TclList.newInstance();
        for (int i = 0; i < selected.length; ++i) {
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclInteger.newInstance((int)selected[i]));
        }
        interp.setResult(list);
    }

    void deleteItems(Interp interp, SwkJList swkjlist, TclObject[] argv) throws TclException {
        if (argv.length < 3 || argv.length > 4) {
            throw new TclNumArgsException(interp, 2, argv, "first ?last");
        }
        String firstArg = argv[2].toString();
        String lastArg = null;
        if (argv.length == 4) {
            lastArg = argv[3].toString();
        }
        new Delete().exec(swkjlist, firstArg, lastArg);
    }

    void getItems(Interp interp, SwkJList swkjlist, TclObject[] argv) throws TclException {
        if (argv.length < 3 || argv.length > 4) {
            throw new TclNumArgsException(interp, 2, argv, "first ?last");
        }
        String firstArg = argv[2].toString();
        String lastArg = null;
        if (argv.length == 4) {
            lastArg = argv[3].toString();
        }
        new Items().exec(swkjlist, firstArg, lastArg);
    }

    void getSize(Interp interp, SwkJList swkjlist, TclObject[] argv) throws TclException {
        if (argv.length != 2) {
            throw new TclNumArgsException(interp, 2, argv, "");
        }
        int size = new Size().exec(swkjlist);
        interp.setResult(size);
    }

    void seeItem(Interp interp, SwkJList swkjlist, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "index");
        }
        new See().exec(swkjlist, argv[2].toString());
    }

    void getIndex(Interp interp, SwkJList swkjlist, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "index");
        }
        int index = new Index().exec(swkjlist, argv[2].toString());
        interp.setResult(index);
    }

    void activate(Interp interp, SwkJList swkjlist, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "index");
        }
        int index = new Activate().exec(swkjlist, argv[2].toString());
        interp.setResult(index);
    }

    void nearest(Interp interp, SwkJList swkjlist, TclObject[] argv) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "y");
        }
        int y = TclInteger.get((Interp)interp, (TclObject)argv[2]);
        int index = new Nearest().exec(swkjlist, y);
        interp.setResult(index);
    }

    void insert(Interp interp, SwkJList swkjlist, TclObject[] argv) throws TclException {
        boolean atEnd = false;
        int start = 3;
        if (argv[2].toString().equals("end")) {
            atEnd = true;
        }
        String[] items = new String[argv.length - start];
        for (int i = start; i < argv.length; ++i) {
            items[i - start] = argv[i].toString();
        }
        int size = new Insert().exec(swkjlist, argv[2].toString(), items, atEnd);
        interp.setResult(size);
    }

    void doSelection(Interp interp, SwkJList swkjlist, TclObject[] argv) throws TclException {
        if (argv.length < 4 || argv.length > 5) {
            throw new TclNumArgsException(interp, 2, argv, "option ?arg");
        }
        if (argv[2].toString().equals("anchor")) {
            if (argv.length != 4) {
                throw new TclNumArgsException(interp, 3, argv, "index");
            }
            new Selection().execAnchor(swkjlist, argv[3].toString());
        } else if (argv[2].toString().equals("clear")) {
            String firstArg = argv[3].toString();
            String lastArg = null;
            if (argv.length == 5) {
                lastArg = argv[4].toString();
            }
            new Selection().execClear(swkjlist, firstArg, lastArg);
        } else if (argv[2].toString().equals("includes")) {
            if (argv.length != 4) {
                throw new TclNumArgsException(interp, 3, argv, "index");
            }
            boolean includes = new Includes().exec(swkjlist, argv[3].toString());
            interp.setResult(includes);
        } else if (argv[2].toString().equals("set")) {
            String firstArg = argv[3].toString();
            String lastArg = null;
            if (argv.length == 5) {
                lastArg = argv[4].toString();
            }
            new Selection().execSet(swkjlist, firstArg, lastArg);
        } else {
            throw new TclException(interp, "bad selection option \"" + argv[2].toString() + "\": must be anchor, clear, includes, or set");
        }
    }

    void viewStuff(Interp interp, SwkJList swkjlist, TclObject[] argv, int opt) throws TclException {
        Result idxResult = new Result();
        switch (opt) {
            case 12: {
                if (argv.length != 5) {
                    throw new TclNumArgsException(interp, 2, argv, "mark|dragto x y");
                }
                int scanX = TclInteger.get((Interp)interp, (TclObject)argv[3]);
                int scanY = TclInteger.get((Interp)interp, (TclObject)argv[4]);
                if (argv[2].toString().equals("mark")) {
                    int markX = scanX;
                    int markY = scanY;
                    break;
                }
                if (argv[2].toString().equals("dragto")) {
                    JViewport jvp;
                    int dragX = scanX;
                    int dragY = scanY;
                    double fy1 = 0.0;
                    if (fy1 < 0.0) {
                        fy1 = 0.0;
                    }
                    if ((jvp = Widgets.getViewport(swkjlist)) == null) break;
                    Point pt = jvp.getViewPosition();
                    Dimension listSize = swkjlist.getSize();
                    pt.y = (int)(fy1 * (double)listSize.height);
                    Dimension extentSize = jvp.getExtentSize();
                    if (pt.y + extentSize.height > listSize.height) {
                        pt.y = listSize.height - extentSize.height;
                    }
                    jvp.setViewPosition(pt);
                    break;
                }
                throw new TclException(interp, "bad scan option \"" + argv[2].toString() + "\": must be mark or dragto");
            }
            case 14: {
                int maxSize = 1;
                int len = 0;
                JViewport jvp = Widgets.getViewport(swkjlist);
                for (int i = 0; i < swkjlist.model.getSize(); ++i) {
                    len = ((String)swkjlist.model.elementAt(i)).length();
                    if (len <= maxSize) continue;
                    maxSize = len;
                }
                if (argv.length == 2) {
                    if (jvp == null) break;
                    Point pt = jvp.getViewPosition();
                    Dimension viewSize = jvp.getViewSize();
                    Dimension listSize = swkjlist.getSize();
                    Dimension extentSize = jvp.getExtentSize();
                    double fx1 = 1.0 * (double)pt.x / (double)listSize.width;
                    double fx2 = 1.0 * (double)(pt.x + extentSize.width) / (double)listSize.width;
                    TclObject list = TclList.newInstance();
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)fx1));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)fx2));
                    interp.setResult(list);
                    break;
                }
                if (argv.length == 3) {
                    swkjlist.getIndex(argv[2].toString(), -1, idxResult);
                    idxResult.checkError(interp);
                    this.index = idxResult.i;
                    double fx1 = 1.0 * (double)this.index / (double)maxSize;
                    if (fx1 < 0.0) {
                        fx1 = 0.0;
                    }
                    Point pt = Widgets.getViewport(swkjlist).getViewPosition();
                    Dimension listSize = swkjlist.getSize();
                    pt.y = (int)(fx1 * (double)listSize.width);
                    if (jvp == null) break;
                    Dimension extentSize = jvp.getExtentSize();
                    if (pt.x + extentSize.width > listSize.width) {
                        pt.x = listSize.width - extentSize.width;
                    }
                    jvp.setViewPosition(pt);
                    break;
                }
                if (argv[2].toString().equals("moveto")) {
                    if (argv.length != 4) {
                        throw new TclNumArgsException(interp, 2, argv, "option ?arg arg ...?");
                    }
                    double fx1 = TclDouble.get((Interp)interp, (TclObject)argv[3]);
                    if (fx1 < 0.0) {
                        fx1 = 0.0;
                    }
                    if (jvp == null) break;
                    Point pt = jvp.getViewPosition();
                    Dimension listSize = swkjlist.getSize();
                    pt.x = (int)(fx1 * (double)listSize.height);
                    Dimension extentSize = jvp.getExtentSize();
                    if (pt.x + extentSize.width > listSize.width) {
                        pt.x = listSize.width - extentSize.width;
                    }
                    jvp.setViewPosition(pt);
                    break;
                }
                if (argv[2].toString().equals("scroll")) {
                    if (argv.length != 5) {
                        throw new TclNumArgsException(interp, 2, argv, "option ?arg arg ...?");
                    }
                    if (argv[4].toString().equals("units")) {
                        if (jvp == null) break;
                        Point pt = jvp.getViewPosition();
                        Dimension viewSize = jvp.getViewSize();
                        Dimension listSize = swkjlist.getSize();
                        Dimension extentSize = jvp.getExtentSize();
                        double fx1 = 1.0 * (double)pt.x / (double)listSize.width;
                        int units = TclInteger.get((Interp)interp, (TclObject)argv[3]);
                        double incrX = listSize.width / maxSize;
                        pt.x = (int)(fx1 * (double)listSize.width + incrX * (double)units);
                        if (pt.x + extentSize.width > listSize.width) {
                            pt.x = listSize.width - extentSize.width;
                        }
                        if (pt.x < 0) {
                            pt.x = 0;
                        }
                        jvp.setViewPosition(pt);
                        break;
                    }
                    if (!argv[4].toString().equals("pages") || jvp == null) break;
                    Point pt = jvp.getViewPosition();
                    Dimension viewSize = jvp.getViewSize();
                    Dimension listSize = swkjlist.getSize();
                    Dimension extentSize = jvp.getExtentSize();
                    double fx1 = 1.0 * (double)pt.x / (double)listSize.width;
                    int units = TclInteger.get((Interp)interp, (TclObject)argv[3]);
                    double incrX = extentSize.width;
                    pt.x = (int)(fx1 * (double)listSize.width + incrX * (double)units);
                    if (pt.x + extentSize.width > listSize.width) {
                        pt.x = listSize.width - extentSize.width;
                    }
                    if (pt.x < 0) {
                        pt.x = 0;
                    }
                    jvp.setViewPosition(pt);
                    break;
                }
                throw new TclException(interp, "unknown option \"" + argv[2].toString() + "\": must be moveto or scroll");
            }
            case 15: {
                JViewport jvp = Widgets.getViewport(swkjlist);
                if (argv.length == 2) {
                    if (jvp == null) break;
                    Point pt = jvp.getViewPosition();
                    Dimension viewSize = jvp.getViewSize();
                    Dimension listSize = swkjlist.getSize();
                    Dimension extentSize = jvp.getExtentSize();
                    double fy1 = 1.0 * (double)pt.y / (double)listSize.height;
                    double fy2 = 1.0 * (double)(pt.y + extentSize.height) / (double)listSize.height;
                    TclObject list = TclList.newInstance();
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)fy1));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)fy2));
                    interp.setResult(list);
                    break;
                }
                if (argv.length == 3) {
                    swkjlist.getIndex(argv[2].toString(), -1, idxResult);
                    idxResult.checkError(interp);
                    this.index = idxResult.i;
                    double fy1 = swkjlist.model.getSize() == 0 ? 1.0 : 1.0 * (double)this.index / (double)swkjlist.model.getSize();
                    if (fy1 < 0.0) {
                        fy1 = 0.0;
                    }
                    if (jvp == null) break;
                    Point pt = jvp.getViewPosition();
                    Dimension listSize = swkjlist.getSize();
                    pt.y = (int)(fy1 * (double)listSize.height);
                    Dimension extentSize = jvp.getExtentSize();
                    if (pt.y + extentSize.height > listSize.height) {
                        pt.y = listSize.height - extentSize.height;
                    }
                    jvp.setViewPosition(pt);
                    break;
                }
                if (argv[2].toString().equals("moveto")) {
                    if (argv.length != 4) {
                        throw new TclNumArgsException(interp, 2, argv, "option ?arg arg ...?");
                    }
                    double fy1 = TclDouble.get((Interp)interp, (TclObject)argv[3]);
                    if (fy1 < 0.0) {
                        fy1 = 0.0;
                    }
                    if (jvp == null) break;
                    Point pt = jvp.getViewPosition();
                    Dimension listSize = swkjlist.getSize();
                    pt.y = (int)(fy1 * (double)listSize.height);
                    Dimension extentSize = jvp.getExtentSize();
                    if (pt.y + extentSize.height > listSize.height) {
                        pt.y = listSize.height - extentSize.height;
                    }
                    jvp.setViewPosition(pt);
                    break;
                }
                if (argv[2].toString().equals("scroll")) {
                    if (argv.length != 5) {
                        throw new TclNumArgsException(interp, 2, argv, "option ?arg arg ...?");
                    }
                    if (argv[4].toString().equals("units")) {
                        if (jvp == null) break;
                        Point pt = jvp.getViewPosition();
                        Dimension viewSize = jvp.getViewSize();
                        Dimension listSize = swkjlist.getSize();
                        Dimension extentSize = jvp.getExtentSize();
                        double fy1 = 1.0 * (double)pt.y / (double)listSize.height;
                        int units = TclInteger.get((Interp)interp, (TclObject)argv[3]);
                        if (swkjlist.model.getSize() == 0) {
                            pt.y = 0;
                        } else {
                            double incrY = listSize.height / swkjlist.model.getSize();
                            pt.y = (int)(fy1 * (double)listSize.height + incrY * (double)units);
                            if (pt.y + extentSize.height > listSize.height) {
                                pt.y = listSize.height - extentSize.height;
                            }
                            if (pt.y < 0) {
                                pt.y = 0;
                            }
                        }
                        jvp.setViewPosition(pt);
                        break;
                    }
                    if (!argv[4].toString().equals("pages") || jvp == null) break;
                    Point pt = jvp.getViewPosition();
                    Dimension viewSize = jvp.getViewSize();
                    Dimension listSize = swkjlist.getSize();
                    Dimension extentSize = jvp.getExtentSize();
                    double fy1 = 1.0 * (double)pt.y / (double)listSize.height;
                    int units = TclInteger.get((Interp)interp, (TclObject)argv[3]);
                    double incrY = extentSize.height;
                    pt.y = (int)(fy1 * (double)listSize.height + incrY * (double)units);
                    if (pt.y + extentSize.height > listSize.height) {
                        pt.y = listSize.height - extentSize.height;
                    }
                    if (pt.y < 0) {
                        pt.y = 0;
                    }
                    jvp.setViewPosition(pt);
                    break;
                }
                throw new TclException(interp, "unknown option \"" + argv[2].toString() + "\": must be moveto or scroll");
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    class Includes
    extends GetValueOnEventThread {
        SwkJList swkjlist = null;
        String item = null;
        boolean includes = false;
        String errMessage = null;

        Includes() {
        }

        boolean exec(SwkJList swkjlist, String item) throws TclException {
            this.item = item;
            this.swkjlist = swkjlist;
            this.execOnThread();
            if (this.errMessage != null) {
                throw new TclException(SwkJListWidgetCmd.this.interp, this.errMessage);
            }
            return this.includes;
        }

        public void run() {
            int index = 0;
            Result result = new Result();
            this.swkjlist.getIndex(this.item, -1, result);
            if (result.hasError()) {
                this.errMessage = result.getErrorMsg();
                return;
            }
            index = result.i;
            this.includes = index >= this.swkjlist.model.getSize() || index < 0 ? false : this.swkjlist.selectionModel.isSelectedIndex(index);
        }
    }

    class Selection
    extends GetValueOnEventThread {
        static final int CLEAR = 0;
        static final int ANCHOR = 1;
        static final int SET = 2;
        SwkJList swkjlist = null;
        String firstArg = null;
        String lastArg = null;
        int mode = 0;
        String errMessage = null;

        Selection() {
        }

        void execClear(SwkJList swkjlist, String firstArg, String lastArg) throws TclException {
            this.firstArg = firstArg;
            this.lastArg = lastArg;
            this.swkjlist = swkjlist;
            this.mode = 0;
            this.execOnThread();
            if (this.errMessage != null) {
                throw new TclException(SwkJListWidgetCmd.this.interp, this.errMessage);
            }
        }

        void execSet(SwkJList swkjlist, String firstArg, String lastArg) {
            this.firstArg = firstArg;
            this.lastArg = lastArg;
            this.swkjlist = swkjlist;
            this.mode = 2;
            this.execOnThread();
        }

        void execAnchor(SwkJList swkjlist, String indexArg) {
            this.firstArg = indexArg;
            this.swkjlist = swkjlist;
            this.mode = 1;
            this.execOnThread();
        }

        void anchor() {
            int index = 0;
            Result result = new Result();
            this.swkjlist.getIndex(this.firstArg, -1, result);
            if (result.hasError()) {
                this.errMessage = result.getErrorMsg();
                return;
            }
            index = result.i;
            if (index >= this.swkjlist.model.getSize()) {
                index = this.swkjlist.model.getSize() - 1;
            }
            this.swkjlist.selectionModel.setSelectionInterval(index, index);
        }

        void clear() {
            int index = 0;
            Result result = new Result();
            this.swkjlist.getIndex(this.firstArg, -1, result);
            if (result.hasError()) {
                this.errMessage = result.getErrorMsg();
                return;
            }
            int index2 = index = result.i;
            if (this.lastArg != null) {
                this.swkjlist.getIndex(this.lastArg, -1, result);
                if (result.hasError()) {
                    this.errMessage = result.getErrorMsg();
                    this.errMessage = result.getErrorMsg();
                    return;
                }
                index2 = result.i;
            }
            if (index >= this.swkjlist.model.getSize()) {
                index = this.swkjlist.model.getSize() - 1;
            }
            if (index2 >= this.swkjlist.model.getSize()) {
                index2 = this.swkjlist.model.getSize() - 1;
            }
            this.swkjlist.selectionModel.removeSelectionInterval(index, index2);
        }

        void set() {
            int index = 0;
            Result result = new Result();
            this.swkjlist.getIndex(this.firstArg, -1, result);
            if (result.hasError()) {
                this.errMessage = result.getErrorMsg();
                return;
            }
            int index2 = index = result.i;
            if (this.lastArg != null) {
                this.swkjlist.getIndex(this.lastArg, -1, result);
                if (result.hasError()) {
                    this.errMessage = result.getErrorMsg();
                    return;
                }
                index2 = result.i;
            }
            if (index >= this.swkjlist.model.getSize()) {
                index = this.swkjlist.model.getSize() - 1;
            }
            if (index2 >= this.swkjlist.model.getSize()) {
                index2 = this.swkjlist.model.getSize() - 1;
            }
            this.swkjlist.selectionModel.addSelectionInterval(index, index2);
        }

        public void run() {
            if (this.mode == 2) {
                this.set();
            } else if (this.mode == 0) {
                this.clear();
            } else if (this.mode == 1) {
                this.anchor();
            }
        }
    }

    class Insert
    extends GetValueOnEventThread {
        SwkJList swkjlist = null;
        int size = 0;
        String[] items = null;
        String idxString = null;
        String errMessage = null;
        boolean atEnd = false;

        Insert() {
        }

        int exec(SwkJList swkjlist, String idxString, String[] items, boolean atEnd) throws TclException {
            this.swkjlist = swkjlist;
            this.items = items;
            this.atEnd = atEnd;
            this.idxString = idxString;
            this.execOnThread();
            if (this.errMessage != null) {
                throw new TclException(SwkJListWidgetCmd.this.interp, this.errMessage);
            }
            return this.size;
        }

        public void run() {
            int index = 0;
            Result result = new Result();
            this.swkjlist.getIndex(this.idxString, -1, result);
            if (result.hasError()) {
                this.errMessage = result.getErrorMsg();
                return;
            }
            index = result.i;
            if (index < 0) {
                index = 0;
            }
            if (index > this.swkjlist.model.getSize()) {
                index = this.swkjlist.model.getSize();
            }
            for (int i = 0; i < this.items.length; ++i) {
                if (this.atEnd) {
                    this.swkjlist.model.addElement(this.items[i]);
                    continue;
                }
                this.swkjlist.model.insertElementAt(this.items[i], index);
                ++index;
            }
            this.size = this.swkjlist.model.getSize();
        }
    }

    class Nearest
    extends GetValueOnEventThread {
        SwkJList swkjlist = null;
        int y = 0;
        int index = 0;

        Nearest() {
        }

        int exec(SwkJList swkjlist, int y) {
            this.swkjlist = swkjlist;
            this.execOnThread();
            return this.index;
        }

        public void run() {
            Point p = new Point(2, 0);
            p.y = this.y;
            JViewport jvp = null;
            try {
                jvp = Widgets.getViewport(this.swkjlist);
            }
            catch (TclException tclE) {
                return;
            }
            if (jvp != null) {
                Dimension extentSize = jvp.getExtentSize();
                if (this.y > extentSize.height) {
                    this.y = extentSize.height - 4;
                }
            }
            this.index = this.swkjlist.locationToIndex(p);
            if (this.index < 0) {
                this.index = 0;
            }
            if (this.index >= this.swkjlist.model.getSize()) {
                this.index = this.swkjlist.model.getSize() - 1;
            }
        }
    }

    class Activate
    extends GetValueOnEventThread {
        SwkJList swkjlist = null;
        String item = null;
        int index = 0;
        String errMessage = null;

        Activate() {
        }

        int exec(SwkJList swkjlist, String item) throws TclException {
            this.item = item;
            this.swkjlist = swkjlist;
            this.execOnThread();
            if (this.errMessage != null) {
                throw new TclException(SwkJListWidgetCmd.this.interp, this.errMessage);
            }
            return this.index;
        }

        public void run() {
            int index = 0;
            Result result = new Result();
            this.swkjlist.getIndex(this.item, -1, result);
            if (result.hasError()) {
                this.errMessage = result.getErrorMsg();
                return;
            }
            index = result.i;
            if (index < 0) {
                index = 0;
            }
            if (index >= this.swkjlist.model.getSize()) {
                index = this.swkjlist.model.getSize() - 1;
            }
            this.swkjlist.active = index;
        }
    }

    class Index
    extends GetValueOnEventThread {
        SwkJList swkjlist = null;
        String item = null;
        int index = 0;
        String errMessage = null;

        Index() {
        }

        int exec(SwkJList swkjlist, String item) throws TclException {
            this.item = item;
            this.swkjlist = swkjlist;
            this.execOnThread();
            if (this.errMessage != null) {
                throw new TclException(SwkJListWidgetCmd.this.interp, this.errMessage);
            }
            return this.index;
        }

        public void run() {
            Result result = new Result();
            this.swkjlist.getIndex(this.item, -1, result);
            if (result.hasError()) {
                this.errMessage = result.getErrorMsg();
                return;
            }
            this.index = result.i;
        }
    }

    class See
    extends UpdateOnEventThread {
        SwkJList swkjlist = null;
        String item = null;
        String errMessage = null;

        See() {
        }

        void exec(SwkJList swkjlist, String item) throws TclException {
            this.item = item;
            this.swkjlist = swkjlist;
            this.execOnThread();
            if (this.errMessage != null) {
                throw new TclException(SwkJListWidgetCmd.this.interp, this.errMessage);
            }
        }

        public void run() {
            int index = 0;
            Result result = new Result();
            this.swkjlist.getIndex(this.item, -1, result);
            if (result.hasError()) {
                this.errMessage = result.getErrorMsg();
                return;
            }
            index = result.i;
            if (index < 0) {
                index = 0;
            }
            if (index >= this.swkjlist.model.getSize()) {
                index = this.swkjlist.model.getSize() - 1;
            }
            this.swkjlist.ensureIndexIsVisible(index);
            this.swkjlist.revalidate();
        }
    }

    class Size
    extends GetValueOnEventThread {
        SwkJList swkjlist = null;
        int size = 0;

        Size() {
        }

        int exec(SwkJList swkjlist) {
            this.swkjlist = swkjlist;
            this.execOnThread();
            return this.size;
        }

        public void run() {
            this.size = this.swkjlist.model.getSize();
        }
    }

    class Items
    extends GetValueOnEventThread {
        SwkJList swkjlist = null;
        String firstArg = null;
        String lastArg = null;
        String errMessage = null;
        ArrayList resultItems = new ArrayList();

        Items() {
        }

        void exec(SwkJList swkjlist, String firstArg, String lastArg) throws TclException {
            this.swkjlist = swkjlist;
            this.firstArg = firstArg;
            this.lastArg = lastArg;
            this.execOnThread();
            if (this.errMessage != null) {
                throw new TclException(SwkJListWidgetCmd.this.interp, this.errMessage);
            }
            SwkJListWidgetCmd.this.interp.setResult("");
            int n = this.resultItems.size();
            if (n == 1) {
                SwkJListWidgetCmd.this.interp.setResult((String)this.resultItems.get(0));
            } else if (n > 1) {
                TclObject list = TclList.newInstance();
                for (int i = 0; i < n; ++i) {
                    TclList.append((Interp)SwkJListWidgetCmd.this.interp, (TclObject)list, (TclObject)TclString.newInstance((String)((String)this.resultItems.get(i))));
                }
                SwkJListWidgetCmd.this.interp.setResult(list);
            }
        }

        public void run() {
            int first = 0;
            Result result = new Result();
            this.swkjlist.getIndex(this.firstArg, -1, result);
            if (result.hasError()) {
                this.errMessage = result.getErrorMsg();
                return;
            }
            int last = first = result.i;
            if (this.lastArg != null) {
                this.swkjlist.getIndex(this.lastArg, -1, result);
                if (result.hasError()) {
                    this.errMessage = result.getErrorMsg();
                    return;
                }
                last = result.i;
            }
            if (first == last) {
                int i = first;
                if (i >= 0 && i < this.swkjlist.model.getSize()) {
                    this.resultItems.add(this.swkjlist.model.elementAt(i).toString());
                }
            } else {
                for (int i = first; i <= last; ++i) {
                    if (i < 0 || i >= this.swkjlist.model.getSize()) continue;
                    this.resultItems.add(this.swkjlist.model.elementAt(i).toString());
                }
            }
        }
    }

    class Delete
    extends UpdateOnEventThread {
        SwkJList swkjlist = null;
        String firstArg = null;
        String lastArg = null;
        String errMessage = null;

        Delete() {
        }

        void exec(SwkJList swkjlist, String firstArg, String lastArg) throws TclException {
            this.firstArg = firstArg;
            this.lastArg = lastArg;
            this.swkjlist = swkjlist;
            this.execOnThread();
            if (this.errMessage != null) {
                throw new TclException(SwkJListWidgetCmd.this.interp, this.errMessage);
            }
        }

        public void run() {
            int first = 0;
            Result result = new Result();
            this.swkjlist.getIndex(this.firstArg, -1, result);
            if (result.hasError()) {
                this.errMessage = result.getErrorMsg();
                return;
            }
            int last = first = result.i;
            if (this.lastArg != null) {
                this.swkjlist.getIndex(this.lastArg, -1, result);
                if (result.hasError()) {
                    this.errMessage = result.getErrorMsg();
                    return;
                }
                last = result.i;
            }
            if (last < first) {
                int hold = last;
                last = first;
                first = hold;
            }
            for (int i = last; i >= first; --i) {
                if (i < 0 || i >= this.swkjlist.model.getSize()) continue;
                this.swkjlist.model.removeElementAt(i);
            }
        }
    }

    class CurrentSelection
    extends GetValueOnEventThread {
        SwkJList swkjlist;
        int[] selected = null;

        CurrentSelection() {
        }

        int[] exec(SwkJList swkjlist) {
            this.swkjlist = swkjlist;
            this.execOnThread();
            return this.selected;
        }

        public void run() {
            this.selected = this.swkjlist.getSelectedIndices();
        }
    }

    class BoundingBox
    extends GetValueOnEventThread {
        SwkJList swkjlist;
        String item = null;
        Rectangle rect = null;
        String errMessage = null;

        BoundingBox() {
        }

        Rectangle exec(SwkJList swkjlist, String item) throws TclException {
            this.swkjlist = swkjlist;
            this.item = item;
            this.execOnThread();
            if (this.errMessage != null) {
                throw new TclException(SwkJListWidgetCmd.this.interp, this.errMessage);
            }
            return this.rect;
        }

        public void run() {
            Result result = new Result();
            int index = 0;
            this.swkjlist.getIndex(this.item, -1, result);
            if (result.hasError()) {
                this.errMessage = result.getErrorMsg();
                return;
            }
            index = result.i;
            if (index < 0 || index >= this.swkjlist.model.getSize()) {
                return;
            }
            this.rect = this.swkjlist.getCellBounds(index, index);
            JViewport jvp = null;
            try {
                jvp = Widgets.getViewport(this.swkjlist);
            }
            catch (TclException tclE) {
                return;
            }
            if (jvp != null) {
                Dimension extentSize = jvp.getExtentSize();
                Point pt = jvp.getViewPosition();
                this.rect.x -= pt.x;
                this.rect.y -= pt.y;
                if (this.rect.y + this.rect.height <= 0 || this.rect.y >= extentSize.height) {
                    this.rect = null;
                }
            }
        }
    }
}

