/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.parameters;

import org.ocamljava.runtime.annotations.parameters.BooleanParameter;
import org.ocamljava.runtime.annotations.parameters.IntegerParameter;
import org.ocamljava.runtime.annotations.parameters.SimpleParameter;
import org.ocamljava.runtime.parameters.CommonParameters;

public interface ByteCodeParameters
extends CommonParameters {
    @SimpleParameter(key="SHOW_DIALOG", commandLineSwitch="dialog", description="show GUI dialog to set parameters")
    public boolean showDialog();

    @SimpleParameter(key="SHOW_HELP", commandLineSwitch="help", description="show help message")
    public boolean showHelp();

    @SimpleParameter(key="SHOW_VERSION", commandLineSwitch="version", description="show program version and exit")
    public boolean showVersion();

    @SimpleParameter(key="SHOW_DISASSEMBLED", commandLineSwitch="disassemble", description="show disassembled program before execution")
    public boolean showDisassembled();

    @SimpleParameter(key="SHOW_SIGNAL_TEST", commandLineSwitch="signal-test", description="show signal test and exit")
    public boolean showSignalTest();

    @IntegerParameter(key="INIT_STACK_SIZE", commandLineSwitch="init-stack-size", guiLabel="Initial stack size:", description="set initial stack size, integer should be >=  512", defaultValue=65536, minValue=512, maxValue=0x100000)
    public int getInitStackSize();

    @IntegerParameter(key="MAX_STACK_SIZE", commandLineSwitch="max-stack-size", guiLabel="Maximum stack size:", description="set maximum stack size, integer should be >=  512", defaultValue=327680, minValue=512, maxValue=0x100000)
    public int getMaxStackSize();

    @BooleanParameter(key="REFLECTION_DISPATCHERS", commandLineSwitch="reflection-dispatchers", guiLabel="Dispatchers:", guiStrings={"handles", "reflection"}, description="whether reflection dispatchers should be used", defaultValue=false)
    public boolean isReflectionUsedForDispatchers();

    public static enum BooleanParameterID {
        REFLECTION_DISPATCHERS;

    }

    public static enum IntegerParameterID {
        INIT_STACK_SIZE,
        MAX_STACK_SIZE;

    }
}

